<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Brand Logo Widget .
 *
 */
class Traga_Brand_Logo extends Widget_Base {

	public function get_name() {
		return 'tragabrandlogo';
	}

	public function get_title() {
		return __( 'Webteck Brand Logo', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'client_logo_section',
			[
				'label' 	=> __( 'Brand Logo', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Band Style', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2' 		=> __( 'Style Two', 'webteck' ),
					'3' 		=> __( 'Style Three', 'webteck' ),
					'4' 		=> __( 'Style Four', 'webteck' ),
					'5' 		=> __( 'Style Five', 'webteck' ),
					'6' 		=> __( 'Style Six', 'webteck' ),
					'7' 		=> __( 'Style Seven', 'webteck' ),
					'8' 		=> __( 'Style Eight', 'webteck' ),
					'9' 		=> __( 'Style Nine', 'webteck' ),
					'10' 		=> __( 'Style Ten', 'webteck' ),
					'11' 		=> __( 'Style Eleven', 'webteck' ),
					'12' 		=> __( 'Style Twelve', 'webteck' ),
					'13' 		=> __( 'Style Thirteen', 'webteck' ),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' 	=> __( 'Section Title', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'webteck' ),
                'condition' => [
					'layout_style' => ['4', '8', '10', '12', '13']
				]
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'client_logo',
			[
				'label' 	=> __( 'Brand Logo', 'webteck' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'logos',
			[
				'label' 		=> __( 'Brand Logos', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
				],
				'condition'	=> ['layout_style' => ['1','2', '3', '4', '5']]
			]
		);

		
        $repeater = new Repeater();

		$repeater->add_control(
			'client_logo',
			[
				'label' 	=> __( 'Brand Logo', 'webteck' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'logo_link',
			[
				'label' 		=> esc_html__( 'Logo Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$this->add_control(
			'logos2',
			[
				'label' 		=> __( 'Brand Logos', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
				],
				'condition'	=> ['layout_style' => ['6','7', '8', '9', '10', '11', '12', '13']]
			]
		);

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------
		webteck_common_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .title', ['4', '8', '10', '12', '13' ] );

	}


	protected function render() {

        $settings = $this->get_settings_for_display();

		if ( $settings['layout_style'] == '1' ) {
			echo '<div class="slider-area text-center">';
				echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
					echo '<div class="swiper-wrapper">';
			        	foreach( $settings['logos'] as $singlelogo ) {
			        		echo '<div class="swiper-slide">';
			                    echo '<div class="brand-box">';
			                        echo webteck_img_tag( array(
			                            'url'   => esc_url( $singlelogo['client_logo']['url'] ),
			                        ) );
			                    echo '</div>';
			                echo '</div>';
				        } 
			        echo '</div>';
		        echo '</div>';
	        echo '</div>';
 
		} elseif ( $settings['layout_style'] == '2' ) {
			echo '<div class="brand-sec1 arrow-wrap">';
				echo '<div class="container py-5">';
					echo '<div class="slider-area text-center">';
						echo '<div class="swiper th-slider" id="brandSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
							echo '<div class="swiper-wrapper">';
								foreach( $settings['logos'] as $singlelogo ) {
									echo '<div class="swiper-slide">';
										echo '<div class="brand-box py-20">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $singlelogo['client_logo']['url'] ),
											) );
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
						echo '<button data-slider-prev="#brandSlider1" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
						echo '<button data-slider-next="#brandSlider1" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif ( $settings['layout_style'] == '3' ) {
			echo '<div class="brand-sec3 overflow-hidden">';
		        echo '<div class="container th-container4">';
		            echo '<div class="slider-area text-center">';
		                echo '<div class="swiper th-slider" id="brandSlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                    	foreach( $settings['logos'] as $singlelogo ) {
			                        echo '<div class="swiper-slide">';
			                            echo '<a href="#" class="brand-box">';
			                                echo webteck_img_tag( array(
												'url'   => esc_url( $singlelogo['client_logo']['url'] ),
											) );
			                            echo '</a>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		           echo '</div>';
		        echo '</div>';
		    echo '</div>';

		} elseif ( $settings['layout_style'] == '4' ) {
			echo '<div class="brand-sec4">';
		        echo '<div class="container th-container4">';
		            echo '<div class="title-area mb-60 text-center">';
		                echo '<h3 class="brand-title mt-n2 title">'.wp_kses_post( $settings['title'] ).'</h3>';
		            echo '</div>';
		            echo '<div class="slider-area text-center">';
		                echo '<div class="swiper th-slider brand-slider4" id="brandSlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"},"1400":{"slidesPerView":"6"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                    	foreach( $settings['logos'] as $singlelogo ) {
			                        echo '<div class="swiper-slide">';
			                            echo '<a href="about.html" class="brand-box">';
			                                echo webteck_img_tag( array(
												'url'   => esc_url( $singlelogo['client_logo']['url'] ),
											) );
			                            echo '</a>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		} elseif ( $settings['layout_style'] == '5' ){
			echo '<div class="brand-sec5 overflow-hidden space">';
		        echo '<div class="container th-container4">';
		            echo '<div class="slider-area text-center">';
		                echo '<div class="swiper th-slider brand-slider5" id="brandSlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"},"1400":{"slidesPerView":"6"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                    	foreach( $settings['logos'] as $singlelogo ) {
		                        
			                        echo '<div class="swiper-slide">';
			                            echo '<div class="brand-item style2">';
			                                echo '<a href="">';
			                                    echo '<img class="original" src="'.esc_url( $singlelogo['client_logo']['url'] ).'" alt="Brand Logo">';
			                                    echo '<img class="gray" src="'.esc_url( $singlelogo['client_logo']['url'] ).'" alt="Brand Logo">';
			                                echo '</a>';
			                            echo '</div>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		} elseif ( $settings['layout_style'] == '6' ){
			echo '<div class="slider-area text-center">';
                echo '<div class="swiper th-slider" id="brandSlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
                    echo '<div class="swiper-wrapper">';
						foreach( $settings['logos2'] as $singlelogo ) {
							echo '<div class="swiper-slide">';
								echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'" class="brand-box style2">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $singlelogo['client_logo']['url'] ),
									) );
								echo '</a>';
							echo '</div>';
						}
                    echo '</div>';

                echo '</div>';
            echo '</div>';

		}elseif ( $settings['layout_style'] == '7' ){
			echo '<div class="slider-area text-center">';
				echo '<div class="swiper th-slider" id="brandSlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['logos2'] as $singlelogo ) {
							echo '<div class="swiper-slide">';
								echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'" class="brand-box style4">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $singlelogo['client_logo']['url'] ),
									) );
								echo '</a>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '8' ){
			echo '<div class="container th-container4">';
				if(!empty($settings['title'])){
					echo '<div class="title-area mb-60 text-center">';
						echo '<h3 class="brand-title9 mt-n2 title">'.wp_kses_post( $settings['title'] ).'</h3>';
					echo '</div>';
				}
				echo '<div class="slider-area text-center">';
					echo '<div class="swiper th-slider brand-slider4" id="brandSlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"},"1400":{"slidesPerView":"6"}}}\'>';
						echo '<div class="swiper-wrapper">';
							foreach( $settings['logos2'] as $singlelogo ) {
								echo '<div class="swiper-slide">';
									echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'" class="brand-box">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $singlelogo['client_logo']['url'] ),
										) );
									echo '</a>';
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '9' ){
			echo '<div class="brand-sec11">';
				echo '<div class="slider-area text-center">';
					echo '<div class="swiper th-slider" id="brandSlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
						echo '<div class="swiper-wrapper">';
							foreach( $settings['logos2'] as $singlelogo ) {
								echo '<div class="swiper-slide">';
									echo '<div class="brand-item style3">';
										echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $singlelogo['client_logo']['url'] ),
												'class' => 'original'
											) );
											echo webteck_img_tag( array(
												'url'   => esc_url( $singlelogo['client_logo']['url'] ),
												'class' => 'gray'
											) );
									echo '</a>';
									echo '</div>';
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '10' ){
			if(!empty($settings['title'])){
				echo '<div class="title-area mb-30 text-center">';
					echo '<h6 class="box-title title">'.wp_kses_post( $settings['title'] ).'</h6>';
				echo '</div>';
			}
			echo '<div class="slider-area text-center">';
				echo '<div class="swiper th-slider" id="brandSlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['logos2'] as $singlelogo ) {
							echo '<div class="swiper-slide">';
								echo '<div class="brand-item style3">';
									echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $singlelogo['client_logo']['url'] ),
											'class' => 'original'
										) );
										echo webteck_img_tag( array(
											'url'   => esc_url( $singlelogo['client_logo']['url'] ),
											'class' => 'gray'
										) );
								echo '</a>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '11' ){
			echo '<div class="brand-area12">';
				echo '<div class="container th-container4">';
					echo '<div class="slider-area text-center">';
						echo ' <div class="swiper th-slider" id="brandSlider12" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
							echo '<div class="swiper-wrapper">';
								foreach( $settings['logos2'] as $singlelogo ) {
									echo '<div class="swiper-slide">';
										echo '<div class="brand-item style4">';
											echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'">';
												echo webteck_img_tag( array(
													'url'   => esc_url( $singlelogo['client_logo']['url'] ),
													'class' => 'original'
												) );
												echo webteck_img_tag( array(
													'url'   => esc_url( $singlelogo['client_logo']['url'] ),
													'class' => 'gray'
												) );
										echo '</a>';
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '12' ){
			if(!empty($settings['title'])){
				echo '<div class="title-area mb-60 text-center">';
					echo '<h3 class="brand-title mt-n2 title">'.wp_kses_post( $settings['title'] ).'</h3>';
				echo '</div>';
			}
			echo '<div class="slider-area text-center">';
				echo '<div class="swiper th-slider brand-slider13" id="brandSlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"},"1400":{"slidesPerView":"6"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['logos2'] as $singlelogo ) {
							echo '<div class="swiper-slide">';
								echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'" class="brand-box">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $singlelogo['client_logo']['url'] ),
										) );
								echo '</a>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '13' ){
			if(!empty($settings['title'])){
				echo '<div class="title-area mb-60 text-center">';
					echo '<h3 class="brand-title mt-n2 title">'.wp_kses_post( $settings['title'] ).'</h3>';
				echo '</div>';
			}
			echo '<div class="slider-area text-center">';
				echo '<div class="swiper th-slider brand-slider4" id="brandSlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"},"1400":{"slidesPerView":"6"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['logos2'] as $singlelogo ) {
							echo '<div class="swiper-slide">';
								echo '<a href="'.esc_url( $singlelogo['logo_link']['url'] ).'" class="brand-box style2">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $singlelogo['client_logo']['url'] ),
									) );
								echo '</a>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}


	}
}