<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * CTA Box Widget .
 *
 */
class Webteck_CTA extends Widget_Base {

	public function get_name() {
		return 'webteckcta';
	}

	public function get_title() {
		return __( 'CTA', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'ctstyle_section',
			[
				'label' 	=> __( 'Style', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'CTA Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'webteck' ),
					'layout_two'  		=> __( 'Style Two', 'webteck' ),
					'layout_three'  	=> __( 'Style Three', 'webteck' ),
					'layout_four'  		=> __( 'Style Four', 'webteck' ),
					'layout_five'  		=> __( 'Style Five', 'webteck' ),
					'layout_six'  		=> __( 'Style Six', 'webteck' ),
					'layout_seven'  	=> __( 'Style Seven', 'webteck' ),

				]
			]
		);
		$this->end_controls_section();

		//---------------------------------------style 1---------------------------------------//
        $this->start_controls_section(
			'ctad_section',
			[
				'label' 	=> __( 'CTA', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> ['layout_style' => ['layout_one']]
			]
        );
        
		$this->add_control(
			'bg',
			[
				'label' 		=> esc_html__( 'Background Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'phone_icon',
			[
				'label' 		=> esc_html__( 'Phone Icon', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'phone_label', [
				'label' 		=> __( 'Phone Label', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Call For More Info' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'phone', [
				'label' 		=> __( 'Phone Number', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( '(+123) 5859 459' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'title', [
				'label' 		=> __( 'CTA Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Let’s Request a Schedule For Free Consultation' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
		$this->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( '#', 'webteck' ),
			]
		);
		
        $this->end_controls_section();

		$this->start_controls_section(
			'ctad3_section',
			[
				'label' 	=> __( 'CTA', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> ['layout_style' => ['layout_two']]
			]
        );

        $this->add_control(
			'title3', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Call For More Info' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'placeholder', [
				'label' 		=> __( 'Placeholder', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Call For More Info' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'btn', [
				'label' 		=> __( 'Button', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( '(+123) 5859 459' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'ctad34_section',
			[
				'label' 	=> __( 'CTA', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> ['layout_style' => ['layout_three']]
			]
        );
        
		$this->add_control(
			'bg2',
			[
				'label' 		=> esc_html__( 'Background', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'subtitle3', [
				'label' 		=> __( 'Subtitle', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'We Make Awesome IT Services For Your Newly Business' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'title33', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lets’s consultation' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'desc3', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( '' , 'webteck' ),
				'rows' 			=> 4,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'button_text3',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
		$this->add_control(
			'button_link3',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		
        $this->end_controls_section();

		$this->start_controls_section(
			'ctad44_section',
			[
				'label' 	=> __( 'CTA', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
        );
		$this->add_control(
			'image4',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'title4', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lets’s consultation' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'desc4', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( '' , 'webteck' ),
				'rows' 			=> 4,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'button_text4',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
		$this->add_control(
			'button_link4',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		
        $this->end_controls_section();

		$this->start_controls_section(
			'ctad55_section',
			[
				'label' 	=> __( 'CTA', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> ['layout_style' => ['layout_five']]
			]
        );
		$this->add_control(
			'image5',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'title5', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lets’s consultation' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'desc5', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( '' , 'webteck' ),
				'rows' 			=> 4,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'button_text5',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
		$this->add_control(
			'button_link5',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$this->add_control(
			'button_text6',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
		$this->add_control(
			'button_link6',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		
        $this->end_controls_section();

		$this->start_controls_section(
			'ctad66_section',
			[
				'label' 	=> __( 'CTA', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> ['layout_style' => ['layout_six']]
			]
        );
		$this->add_control(
			'image6',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'title6', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lets’s consultation' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'button_text66',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
		$this->add_control(
			'button_link66',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		
        $this->end_controls_section();

		$this->start_controls_section(
			'ctad7_section',
			[
				'label' 	=> __( 'CTA', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> ['layout_style' => ['layout_seven']]
			]
        );
		$this->add_control(
			'subtitle7', [
				'label' 		=> __( 'Subitle', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Join With Us' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'title7', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lets’s consultation' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'desc7', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( '' , 'webteck' ),
				'rows' 			=> 4,
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'newsletter_placeholder', [
				'label' 		=> __( 'Placeholder', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Enter your Email' , 'webteck' ),
				'rows' 			=> 2,
			]
		);
		$this->add_control(
			'newsletter_button', [
				'label' 		=> __( 'Subscribe Button', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Subscribe' , 'webteck' ),
				'rows' 			=> 2,
			]
		);
		
        $this->end_controls_section();


        //-------------------------------------title styling-------------------------------------//
        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Style', 'webteck' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		webteck_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one'], '--white-color' );
		webteck_all_elementor_style($this, 'Title ', '{{WRAPPER}} .title-selector',['layout_one'], '--title-color' );

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------
		webteck_common_style_fields($this, 'sub2', 'Subtitle', '{{WRAPPER}} .sub', ['layout_three', 'layout_seven']);
		webteck_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .title', ['layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven'] );
		webteck_common_style_fields($this, 'desc2', 'Description', '{{WRAPPER}} .desc', ['layout_three', 'layout_four', 'layout_five', 'layout_seven']);

		//------Button Style-------
		webteck_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th_btn', ['layout_three', 'layout_four', 'layout_five', 'layout_six'] );
		webteck_button_style_fields( $this, '13', 'Button Styling', '{{WRAPPER}} .th_btn2', ['layout_five'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
        	$phone      = $settings['phone'];

	        $replace        = array(' ','-',' - ');
	        $with           = array('','','');

	        $phoneurl       = str_replace( $replace, $with, $phone );

        	echo '<section class="overflow-hidden">';
		        echo '<div class="container th-container4">';
		            echo '<div class="cta-sec6 bg-theme background-image" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
		                echo '<div class="cta-content">';
		                    echo '<div class="cta-wrapper">';
		                    	if( ! empty( $settings['phone_icon']['url'] ) ){
			                        echo '<div class="cta-icon">';
			                            echo '<a href="'.esc_attr( 'tel:'.$phoneurl ).'"><img src="'.esc_url( $settings['phone_icon']['url'] ).'" alt=""></a>';
			                        echo '</div>';
			                    }
		                        echo '<div class="media-body">';
		                            echo '<span class="header-info_label text-white ">'.esc_html( $settings['phone_label'] ).'</span>';
		                            echo '<p class="header-info_link"><a href="'.esc_attr( 'tel:'.$phoneurl ).'">'.esc_html( $settings['phone'] ).'</a></p>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="title-area mb-0">';
		                        echo '<h4 class="sec-title text-white title-selector">'.esc_html( $settings['title'] ).'</h4>';
		                    echo '</div>';
		                    echo '<div class="cta-group">';
		                        echo '<a href="'.esc_url( $settings['button_link'] ).'" class="th-btn th-border style-radius">'.esc_html( $settings['button_text'] ).'</a>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</section>';

	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="footer-top">';
                echo '<div class="row gx-0 align-items-center">';
                    echo '<div class="col-xl">';
                        echo '<div class="footer-newsletter">';
                            echo '<div class="footer-newsletter-content">';
                                echo '<h2 class="newsletter-title">'.esc_html( $settings['title3'] ).'</h2>';
                            echo '</div>';
                            echo '<form class="newsletter-form">';
                                echo '<i class="fa-sharp fa-light fa-envelope"></i>';
                                echo '<input class="form-control" type="email" placeholder="'.esc_attr( $settings['placeholder'] ).'" required="">';
                                echo '<button type="submit" class="th-btn">'.esc_html( $settings['btn'] ).'</button>';
                            echo '</form>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_three' ){
			echo '<div class="contact-area5 space" data-bg-src="'.esc_url( $settings['bg2']['url'] ).'" id="contact-sec">';
				echo '<div class="container th-container4">';
					echo '<div class="row">';
						echo '<div class="col-xl-6">';
							echo '<div class="title-area mb-40 text-xl-start text-center">';
								if(!empty($settings['subtitle3'])){
									echo '<span class="sub-title sub">'.wp_kses_post($settings['subtitle3']).'</span>';
								}
								if(!empty($settings['title33'])){
									echo '<h2 class="sec-title title">'.wp_kses_post($settings['title33']).'</h2>';
								}
								if(!empty($settings['desc3'])){
									echo '<p class="sec-text desc style3 pe-xl-5">'.wp_kses_post($settings['desc3']).'</p>';
								}
							echo '</div>';
							if(!empty($settings['button_text3'])){
								echo '<div class="contact-btn"><a href="'.esc_url( $settings['button_link3']['url'] ).'" class="th-btn style9 th_btn style-radius">'.esc_html($settings['button_text3']).'</a></div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				if (!empty($settings['image']['url'])) {
					echo '<div class="contact-shape">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<div class="software-area">';
				echo '<div class="row align-items-center">';
					echo '<div class="col-xl-5">';
						echo '<div class="software-content">';
							echo '<div class="title-area mb-10 pe-xl-5 me-xl-3">';
								if(!empty($settings['title4'])){
									echo '<h2 class="sec-title sec-title2 title">'.wp_kses_post($settings['title4']).'</h2>';
								}
								if(!empty($settings['desc4'])){
									echo '<p class="mb-30 desc">'.wp_kses_post($settings['desc4']).'</p>';
								}
							echo '</div>';
							if(!empty($settings['button_text4'])){
								echo '<div class="contact-btn"><a href="'.esc_url( $settings['button_link4']['url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.esc_html($settings['button_text4']).'</a></div>';
							}
						echo '</div>';
					echo '</div>';
					echo '<div class="col-xl-7">';
						echo '<div class="soft-wrapper">';
							if (!empty($settings['image4']['url'])) {
								echo '<div class="soft-image">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $settings['image4']['url']  ),
									));
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="cta-area10 space text-center" data-bg-src="'.esc_url( $settings['image5']['url']  ).'">';
				echo '<div class="row">';
					echo '<div class="col-lg-8 offset-lg-2">';
						echo '<div class="title-area mb-25 text-center">';
							if(!empty($settings['title5'])){
								echo '<h2 class="sec-title title">'.wp_kses_post($settings['title5']).'</h2>';
							}
							if(!empty($settings['desc5'])){
								echo '<p class="cta-text desc">'.wp_kses_post($settings['desc5']).'</p>';
							}
						echo '</div>';
						echo '<div class="btn-group justify-content-center">';
							if(!empty($settings['button_text5'])){
								echo '<a href="'.esc_url( $settings['button_link5']['url'] ).'" class="th-btn style4 style-radius text-capitalize th_btn">'.esc_html($settings['button_text5']).'</a>';
							}
							if(!empty($settings['button_text6'])){
								echo '<a href="'.esc_url( $settings['button_link6']['url'] ).'" class="th-btn style2 style-radius text-capitalize th_btn2">'.esc_html($settings['button_text6']).'</a>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_six' ){
			echo '<div class="widget widget_cta" data-bg-src="'.esc_url( $settings['image6']['url']  ).'">';
				echo '<div class="cta-banner">';
					if(!empty($settings['title6'])){
						echo '<h5 class="banner-title title">'.wp_kses_post($settings['title6']).'</h5>';
					}
					if(!empty($settings['button_text66'])){
						echo '<a href="'.esc_url( $settings['button_link66']['url'] ).'" class="th-btn style9 th_btn">'.esc_html($settings['button_text66']).'</a>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_seven' ){
			echo '<div class="cta-area11 space-extra2 text-center">';
				echo '<div class="row justify-content-center">';
					echo '<div class="col-lg-7">';
						echo '<div class="title-area mb-25 text-center">';
							if(!empty($settings['subtitle7'])){
								echo '<span class="sub-title sub-title7 sub">'.esc_html($settings['subtitle7']).'</span>';
							}
							if(!empty($settings['title7'])){
								echo '<h2 class="sec-title title">'.esc_html($settings['title7']).'</h2>';
							}
							if(!empty($settings['desc7'])){
								echo '<p class="cta-text3 desc">'.esc_html($settings['desc7']).'</p>';
							}
						echo '</div>';
						echo '<form class="newsletter-form style2">';
							echo '<i class="fa-sharp fa-light fa-envelope"></i>';
							echo '<input class="form-control" type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
							echo '<button type="submit" class="th-btn style3">'.esc_html( $settings['newsletter_button'] ).'</button>';
						echo '</form>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}



	}
}