<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Box Widget .
 *
 */
class Webteck_Game_Feature extends Widget_Base {

	public function get_name() {
		return 'webteckgamefeature';
	}

	public function get_title() {
		return __( 'Game Feature', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Feature', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Feature Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2'  		=> __( 'Style Two', 'webteck' ),
				],
			]
		);

		webteck_media_fields( $this, 'shape', 'Choose Background Shappe' );
		webteck_media_fields( $this, 'image', 'Choose Image' );
        webteck_url_fields( $this, 'video_url', 'Video URL' );
        
		webteck_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Empire Forge -' );
		webteck_general_fields( $this, 'subtitle', 'Subitle', 'TEXTAREA2', 'Rise of Alliances' );
		webteck_general_fields( $this, 'tag', 'Tags', 'TEXTAREA', '' );
		webteck_general_fields( $this, 'desc', 'Description', 'TEXTAREA', '' );
        
		webteck_general_fields( $this, 'button_text', 'Button Text', 'TEXT', 'Get Started' );
		webteck_url_fields( $this, 'button_url', 'Button URL' );

        webteck_media_fields( $this, 'logo', 'Choose Logo' );
        webteck_general_fields( $this, 'content1', 'Content 1', 'TEXTAREA', '' );
        webteck_general_fields( $this, 'content2', 'Content 2', 'TEXTAREA', '' );

        $repeater = new Repeater();

		webteck_media_fields( $repeater, 'image', 'Choose Image' );
		webteck_url_fields( $repeater, 'image_url', 'Image URL' );

        $this->add_control(
			'image_lists',
			[
				'label' 		=> __( 'Image Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
			]
		);

        $this->end_controls_section();


       	//---------------------------------------
			//Style Section Start
		//---------------------------------------
		webteck_common_style_fields($this, 'title22', 'Title', '{{WRAPPER}} .title', ['1', '2'] );
		webteck_common_style_fields($this, 'sub22', 'Subtitle', '{{WRAPPER}} .sub', ['1', '2']);
		webteck_common_style_fields($this, 'desc22', 'Description', '{{WRAPPER}} .desc', ['1', '2'] );


	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if ( $settings['layout_style'] == '1' || $settings['layout_style'] == '2'  ){
            if ( $settings['layout_style'] == '2' ){
                $row = 'flex-row-reverse';
                $video = 'video-img';
            }else{
                $row = '';
                $video = '';
            }
        	echo '<div class="feature-wrap12" data-bg-src="'.esc_url($settings['shape']['url']).'">';
                echo '<div class="row '.esc_attr($row).'">';
                   echo '<div class="col-xl-5">';
                    if (!empty($settings['image']['url'])) {
                            echo '<div class="feature-image12 '.esc_attr($video).'">';
                                echo webteck_img_tag( array(
                                    'url'   => esc_url( $settings['image']['url']  ),
                                ));
                                if(!empty($settings['video_url']['url'])){
                                    echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
                                }
                            echo '</div>';
                    }
                    echo '</div>';
                    echo '<div class="col-xl-7">';
                        echo '<div class="feature-content12">';
                            echo '<div class="feature-title-area">';
                                echo '<div class="title-wrapp">';
                                    if(!empty($settings['title'])){
                                        echo '<h4 class="box-title title">'.esc_html($settings['title']).'</h4>';
                                    }
                                    if(!empty($settings['subtitle'])){
                                        echo '<span class="sub">'.esc_html($settings['subtitle']).'</span>';
                                    }
                                echo '</div>';
                                if(!empty($settings['button_text'])){
                                    echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style-radius btn-gradient">'.esc_html($settings['button_text']).'</a>';
                                }
                            echo '</div>';
                            if(!empty($settings['tag'])){
                                echo '<div class="feature-meta">'.wp_kses_post($settings['tag']).'</div>';
                            }
                            if(!empty($settings['desc'])){
                                echo '<p class="feature-text12 desc">'.esc_html($settings['desc']).'</p>';
                            }
                            if ( !empty($settings['logo']['url']) || !empty($settings['content1']) || !empty($settings['content2']) ) {
                                echo '<div class="feature-counter">';
                                    if (!empty($settings['logo']['url'])) {
                                        echo '<div class="feature-logo">';
                                            echo webteck_img_tag( array(
                                                'url'   => esc_url( $settings['logo']['url']  ),
                                            ));
                                        echo '</div>';
                                    }
                                    if(!empty($settings['content1'])){
                                        echo '<div class="divider"></div>';
                                        echo '<div class="feature-year-counter">';
                                            echo wp_kses_post($settings['content1']);
                                        echo '</div>';
                                    }
                                    if(!empty($settings['content2'])){
                                        echo '<div class="divider"></div>';
                                        echo '<div class="feature-year-counter">';
                                            echo wp_kses_post($settings['content2']);
                                        echo '</div>';
                                    }
                                echo '</div>';
                            }
                            echo '<div class="download-btn-wrap">';
                                foreach( $settings['image_lists'] as $data ) { 
                                    echo '<div class="">';
                                        echo '<a target="_blank" href="'.esc_url( $data['image_url']['url'] ).'" class="download-btn">';
                                            echo webteck_img_tag( array(
                                                'url'   => esc_url( $data['image']['url']  ),
                                            ));
                                        echo '</a>';
                                    echo '</div>';
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

	    }elseif ( $settings['layout_style'] == '3' ){
	    	

	    }


	}
}