<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Background;
/**
 * 
 * Newsletter Widget .
 *
 */
class Webteck_Newsletter extends Widget_Base {

	public function get_name() {
		return 'webtecknewsletter';
	}
	public function get_title() {
		return __( 'Newsletter', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label'     => __( 'Newsletter Style', 'webteck' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		webteck_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] );
		
		webteck_general_fields( $this, 'title', 'Title', 'TEXT', 'Sign Up For Newsletter', ['1', '2'] );
		webteck_general_fields( $this, 'icon', 'Input Icon', 'TEXT', '', ['1', '2', '3'] );
		webteck_general_fields( $this, 'newsletter_placeholder', 'Placeholder', 'TEXT', 'Enter your Email' );
		webteck_general_fields( $this, 'newsletter_button', 'Subscribe Button', 'TEXT', 'Subscribe' );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		webteck_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .title', ['1', '2'] );
		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="footer-newsletter">';
                if($settings['title']){
                    echo '<div class="footer-newsletter-content">';
                        echo '<h2 class="newsletter-title title">'.esc_html($settings['title']).'</h2>';
                    echo '</div>';
                }
                echo '<form class="newsletter-form">';
                    echo wp_kses_post( $settings['icon'] );
                    echo '<input class="form-control" type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
                    echo '<button type="submit" class="th-btn">'.esc_html( $settings['newsletter_button'] ).'</button>';
                echo '</form>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="footer-newsletter">';
				if($settings['title']){
					echo '<div class="footer-newsletter-content">';
						echo '<h2 class="newsletter-title title">'.esc_html($settings['title']).'</h2>';
					echo '</div>';
				}
				echo '<form class="newsletter-form">';
					echo wp_kses_post( $settings['icon'] );
					echo '<input class="form-control" type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
					echo '<button type="submit" class="th-btn style3">'.esc_html( $settings['newsletter_button'] ).'</button>';
				echo '</form>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="newsletter-wrapper">';
				echo '<form class="newsletter-form3">';
					echo wp_kses_post( $settings['icon'] );
					echo '<input class="form-control" type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
					echo '<button type="submit" class="th-btn2">'.esc_html( $settings['newsletter_button'] ).'</button>';
				echo '</form>';
			echo '</div>';

		}
	

	}
}
						