<?php
/**
 * This file contains code related to the brands only.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Megamenu;

use Walker_Nav_Menu_Edit;
use WP_Post;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Megamenu\Walker' ) ) {
	/**
	 * Class Walker
	 */
	class Walker extends Walker_Nav_Menu_Edit {
		/**
		 * Start the element output.
		 *
		 * @param string  $output Used to append additional content (passed by reference).
		 * @param WP_Post $item   Menu item data object.
		 * @param int     $depth  Depth of menu item. Used for padding.
		 * @param array   $args   Not used.
		 * @param int     $id     Not used.
		 *
		 * @noinspection PhpMissingParamTypeInspection
		 */
		public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			$item_output = '';

			parent::start_el( $item_output, $item, $depth, $args, $id );

			$output .= preg_replace(
				'/(?=<(fieldset|p)[^>]+class="[^"]*field-move)/',
				$this->get_fields( $item, $depth ),
				$item_output
			);
		}

		/**
		 * Get custom fields
		 *
		 * @param object $item   Menu item data object.
		 * @param int    $depth  Depth of menu item. Used for padding.
		 *
		 * @return string Form fields
		 */
		protected function get_fields( $item, int $depth ): string {
			ob_start();

			$item_id     = esc_attr( $item->ID );
			$menu_id     = get_post_meta( $item->ID, '_redparts_megamenu_menu_id', true );
			$size        = get_post_meta( $item->ID, '_redparts_megamenu_size', true );
			$image       = get_post_meta( $item->ID, '_redparts_megamenu_image', true );
			$column_size = get_post_meta( $item->ID, '_redparts_megamenu_column_size', true );

			$sizes = array(
				'sm' => esc_html__( 'Small', 'redparts-sputnik' ),
				'nl' => esc_html__( 'Normal', 'redparts-sputnik' ),
				'md' => esc_html__( 'Medium', 'redparts-sputnik' ),
				'lg' => esc_html__( 'Large', 'redparts-sputnik' ),
				'xl' => esc_html__( 'Extra Large', 'redparts-sputnik' ),
			);
			$size  = array_key_exists( $size, $sizes ) ? $size : 'nl';

			$column_sizes = array(
				'1',
				'2',
				'3',
				'4',
				'5',
				'6',
				'7',
				'8',
				'9',
				'10',
				'11',
				'12',
				'1of5',
				'2of5',
				'3of5',
				'4of5',
				'5of5',
			);
			$column_size  = in_array( $column_size, $column_sizes, true ) ? $column_size : '1';

			if ( 'redparts_megamenu_column' === $item->type ) {
				?>
				<p class="field-redparts-megamenu-column-size description description-thin">
					<label for="edit-menu-item-redparts-megamenu-column-size-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Column Size', 'redparts-sputnik' ); ?><br>
						<select
							id="edit-menu-item-redparts-megamenu-column-size-<?php echo esc_attr( $item_id ); ?>"
							name="menu-item-redparts-megamenu-column-size[<?php echo esc_attr( $item_id ); ?>]"
						>
							<?php foreach ( $column_sizes as $key ) : ?>
								<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $column_size ); ?>>
									<?php echo esc_html( $key ); ?>
								</option>
							<?php endforeach; ?>
						</select>
					</label>
				</p>
				<?php
			}

			if ( 0 === $depth ) {
				$menus = wp_get_nav_menus();

				?>
				<div class="clear"></div>
				<p class="field-redparts-megamenu-menu-id description description-thin">
					<label for="edit-menu-item-redparts-megamenu-menu-id-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Megamenu', 'redparts-sputnik' ); ?><br>
						<select
							id="edit-menu-item-redparts-megamenu-menu-id-<?php echo esc_attr( $item_id ); ?>"
							name="menu-item-redparts-megamenu-menu-id[<?php echo esc_attr( $item_id ); ?>]"
						>
							<option value="" <?php selected( $menu_id, '' ); ?>><?php esc_html_e( 'None', 'redparts-sputnik' ); ?></option>
							<?php foreach ( $menus as $menu ) : ?>
								<option value="<?php echo esc_attr( $menu->term_id ); ?>" <?php selected( $menu_id, $menu->term_id ); ?>>
									<?php echo esc_html( $menu->name ); ?>
								</option>
							<?php endforeach; ?>
						</select>
					</label>
				</p>
				<p class="field-redparts-megamenu-size description description-thin">
					<label for="edit-menu-item-redparts-megamenu-size-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Megamenu Size', 'redparts-sputnik' ); ?><br>
						<select
							id="edit-menu-item-redparts-megamenu-size-<?php echo esc_attr( $item_id ); ?>"
							name="menu-item-redparts-megamenu-size[<?php echo esc_attr( $item_id ); ?>]"
						>
							<?php foreach ( $sizes as $key => $label ) : ?>
								<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $size ); ?>>
									<?php echo esc_html( $label ); ?>
								</option>
							<?php endforeach; ?>
						</select>
					</label>
				</p>
				<div class="field-redparts-megamenu-image description description-wide">
					<label for="edit-menu-item-redparts-megamenu-image-<?php echo esc_attr( $item_id ); ?>">
						<?php esc_html_e( 'Megamenu Image', 'redparts-sputnik' ); ?><br>
					</label>
					<?php
					$classes    = array( 'redparts-image-picker' );
					$image_html = wp_get_attachment_image( $image, 'full' );

					if ( $image_html ) {
						$classes[] = 'redparts-image-picker--has-image';
					}
					?>
					<div class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
						<input
							type="hidden"
							id="edit-menu-item-redparts-megamenu-image-<?php echo esc_attr( $item_id ); ?>"
							name="menu-item-redparts-megamenu-image[<?php echo esc_attr( $item_id ); ?>]"
							value="<?php echo esc_attr( $image ); ?>"
						>
						<button class="redparts-image-picker__button" type="button">
							<?php esc_html_e( 'Select Image', 'redparts-sputnik' ); ?>
						</button>
						<div class="redparts-image-picker__container">
							<?php echo wp_kses( $image_html, 'redparts_sputnik_image' ); ?>
						</div>
						<div class="redparts-image-picker__actions">
							<a class="redparts-image-picker__remove redparts-link--warning" href="#">
								<?php esc_html_e( 'Remove Image', 'redparts-sputnik' ); ?>
							</a>
							<span>|</span>
							<a class="redparts-image-picker__replace" href="#">
								<?php esc_html_e( 'Replace Image', 'redparts-sputnik' ); ?>
							</a>
						</div>
					</div>
				</div>
				<?php
			}

			return ob_get_clean();
		}
	}
}
