<?php
/**
 * Footer newsletter widget.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Widgets;

use RedParts\Sputnik\Widget;
use RedParts\Sputnik\Social_Links;
use MC4WP_Form;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Widgets\Footer_Newsletter' ) ) {
	/**
	 * Class Footer_Newsletter
	 */
	class Footer_Newsletter extends Widget {
		/**
		 * Constructor.
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'                   => 'widget_redparts_sputnik_footer_newsletter',
				'description'                 => esc_html_x( 'Displays newsletter form in the footer.', 'Admin', 'redparts-sputnik' ),
				'customize_selective_refresh' => true,
			);

			parent::__construct(
				'redparts_sputnik_footer_newsletter',
				esc_html_x( 'RedParts: Footer Newsletter', 'Admin', 'redparts-sputnik' ),
				$widget_ops
			);
		}

		/**
		 * Echoes the widget body content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		protected function widget_body( array $args, array $instance ) {
			$form        = '';
			$social_text = '';

			if ( ! empty( $instance['form'] ) && function_exists( 'mc4wp_show_form' ) ) {
				$form = $instance['form'];
			}

			if ( ! empty( $instance['social_text'] ) ) {
				$social_text = $instance['social_text'];
			}

			?>
			<div class="th-footer-newsletter">
				<?php
				if ( $form ) {
					mc4wp_show_form( apply_filters( 'wpml_object_id', $form, 'mc4wp-form', true ) );
				}
				?>

				<?php if ( $social_text ) : ?>
					<div class="th-footer-newsletter__text">
						<?php echo wp_kses( $social_text, 'redparts_sputnik_text' ); ?>
					</div>
				<?php endif; ?>

				<?php Social_Links::instance()->render( 'th-footer-newsletter__social-links' ); ?>
			</div>
			<?php
		}

		/**
		 * Returns form fields.
		 *
		 * @return array
		 */
		public function form_fields(): array {
			$forms = array(
				array(
					'key'   => '',
					'label' => esc_html__( 'Select form', 'redparts-sputnik' ),
				),
			);

			if ( function_exists( 'mc4wp_get_forms' ) ) {
				$form_objects = mc4wp_get_forms();

				if ( ! is_array( $form_objects ) ) {
					$form_objects = array();
				}

				/** Form object. @var MC4WP_Form $form_object */
				foreach ( $form_objects as $form_object ) {
					$form_name = $form_object->name;

					if ( ! $form_name ) {
						/* translators: %s: Form ID. */
						$form_name = sprintf( esc_html__( 'Form ID: %s', 'redparts-sputnik' ), $form_object->ID );
					}

					$forms[] = array(
						'key'   => (string) $form_object->ID,
						'label' => $form_name,
					);
				}
			}

			return array(
				array(
					'key'          => 'title',
					'label'        => esc_html__( 'Title', 'redparts-sputnik' ),
					'type'         => 'text',
					'translatable' => $this->is_elementor_widget(),
				),
				array(
					'key'     => 'form',
					'label'   => esc_html__( 'Subscription form', 'redparts-sputnik' ),
					'type'    => 'select',
					'options' => $forms,
				),
				array(
					'key'          => 'social_text',
					'label'        => esc_html__( 'Text before social links', 'redparts-sputnik' ),
					'type'         => 'textarea',
					'translatable' => true,
				),
			);
		}
	}
}
