<?php

include  WC_SCM_PLUGIN_PATH.'/includes/azure/vendor/autoload.php';

use WindowsAzure\Common\ServicesBuilder;
use WindowsAzure\Common\ServiceException;
use WindowsAzure\ServiceBus\Models\QueueInfo;
use WindowsAzure\ServiceBus\Models\BrokeredMessage;

class AzureServices {
	
	public static function sync_data($order_details) {
		$connection = self::connect_to_server();
		self::send_message($connection,$order_details);
		return true;
	}

	public static function connect_to_server() {
		// Create Service Bus REST proxy.
		$endpoint_details = get_option('wc_settings_scmprofit_endpoint');
		//$connection_string = "Endpoint=https://klogecomtest.servicebus.windows.net/;SharedAccessKeyName=allPolicies;SharedAccessKey=+WMhD9U54AJ+5NhWJTb7MdzPV6jJn7vMLiEq9yC/TN4=";
		//echo $endpoint_details;die;
		$connection_string = $endpoint_details;
		$serviceBusRestProxy = ServicesBuilder::getInstance()->createServiceBusService($connection_string);
		return $serviceBusRestProxy;
	}
	
	public static function send_message($connection,$order_details) {
		$queue_name = get_option('wc_settings_scmprofit_queue_name');
		$customer_id = get_option('wc_settings_scmprofit_customer_id');
		$customer_name = get_option('wc_settings_scmprofit_customer_name');
		//echo $queue_name;die;
		try {
			
			$message = new BrokeredMessage();
			$message->setContentType('text/xml');
			$message->setLabel('Order');
			$message->setProperty('CustomerId',$customer_id);
			$message->setProperty('CustomerName',$customer_name);
			$message->setBody($order_details);
			//send message
			$connection->sendQueueMessage($queue_name, $message);
		}
		catch(ServiceException $e){
			// Handle exception based on error codes and messages.
			$code = $e->getCode();
			$error_message = $e->getMessage();
			echo $code.": ".$error_message."<br />";
		}
		return true;
	}
	
	public static function sync_data_product($product_details) {
		$connection = self::connect_to_server_product_token($product_details);		
		return true;
	}
	
	public static function connect_to_server_product_token($product_details) {
		$product_token = get_option('wc_settings_product_token');
		$product_username = get_option('wc_settings_product_api_username');
		$product_password = get_option('wc_settings_product_api_password');
		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $product_token,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS => 'grant_type=password&username='.$product_username.'&password='.$product_password,
		  CURLOPT_HTTPHEADER => array(
			'Content-Type: application/x-www-form-urlencoded'
		  ),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$result = json_decode($response, true);		
		
		$connection = self::send_product_to_scm($product_details, $result);
	}	

	public static function send_product_to_scm($product_details, $result) {
		$product_api_url = get_option('wc_settings_product_api_url');
		$bearer = $result['token_type'];
		$access_token = $result['access_token'];
		//echo 'Authorization: '.$bearer.' '.$access_token;
		
		//echo $product_details;die;
		$curl = curl_init();

		curl_setopt_array($curl, array(
		CURLOPT_URL => $product_api_url,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_SSL_VERIFYPEER => false,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS =>$product_details,
		CURLOPT_HTTPHEADER => array(
		'Authorization: '.$bearer.' '.$access_token,
		'Content-Type: application/xml'
		),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		echo $response;
		//$result = json_decode($response, true);	
		//die;
	}
	
}
