( function( $ ) {
	'use strict';

	try {
		$( document.body )
			.on( 'wc-enhanced-select-init', function() {
				$( '.redparts-sputnik-lazy-select' ).filter( ':not(.redparts-sputnik-lazy-select--active)' ).each( function() {
					const ajaxUrl = $( this ).data( 'ajax-url' );
					const attributeId = $( this ).data( 'attribute-id' );
					const args = {
						minimumResultsForSearch: 10,
						placeholder: $( this ).data( 'placeholder' ),
						ajax: {
							type: 'get',
							url: ajaxUrl,
							dataType: 'json',
							delay: 250,
							data: function( params ) {
								return {
									action: 'redparts_sputnik_lazy_select_terms',
									attribute_id: attributeId,
									s: params.term,
								};
							},
							processResults: function( data ) {
								return {
									results: data.data,
								};
							},
							cache: true,
						},
						minimumInputLength: 1,
					};

					$( this ).selectWoo( args ).addClass( 'redparts-sputnik-lazy-select--active' );
				} );
			} )
			.trigger( 'wc-enhanced-select-init' );
	} catch ( error ) {
		window.console.error( error );
	}
}( jQuery ) );
