<?php
/**
 * This file contains helpers and other code used in the admin panel only.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Admin' ) ) {
	/**
	 * Class Admin
	 */
	class Admin extends Singleton {
		/**
		 * Initialization.
		 */
		public function init() { }

		/**
		 * Outputs image form field.
		 *
		 * @param string   $field_name    Form field name.
		 * @param int|null $attachment_id Image ID.
		 */
		public function the_image_field( string $field_name, $attachment_id = null ) {
			$classes    = array( 'redparts-image-picker' );
			$image_html = wp_get_attachment_image( $attachment_id, 'full' );

			if ( $image_html ) {
				$classes[] = 'redparts-image-picker--has-image';
			}
			?>
			<div class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
				<input
					type="hidden"
					name="<?php echo esc_attr( $field_name ); ?>"
					value="<?php echo esc_attr( $attachment_id ); ?>"
				>
				<button class="redparts-image-picker__button" type="button">
					<?php esc_html_e( 'Select Image', 'redparts-sputnik' ); ?>
				</button>
				<div class="redparts-image-picker__container">
					<?php echo wp_kses( $image_html, 'redparts_sputnik_image' ); ?>
				</div>
				<div class="redparts-image-picker__actions">
					<a class="redparts-image-picker__remove redparts-link--warning" href="#">
						<?php esc_html_e( 'Remove Image', 'redparts-sputnik' ); ?>
					</a>
					<span>|</span>
					<a class="redparts-image-picker__replace" href="#">
						<?php esc_html_e( 'Replace Image', 'redparts-sputnik' ); ?>
					</a>
				</div>
			</div>
			<?php
		}
	}
}
