/*
 * Field Color Gradient
 */

/*global redux */

( function( $ ) {
	'use strict';

	redux.field_objects = redux.field_objects || {};
	redux.field_objects.redparts_vehicle_fields = redux.field_objects.redparts_vehicle_fields || {};

	redux.field_objects.redparts_vehicle_fields.init = function( selector ) {
		selector = $.redux.getSelector( selector, 'redparts_vehicle_fields' );

		$( selector ).each(
			function() {
				const el = $( this );
				let parent = el;

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				if ( parent.hasClass( 'redux-field-init' ) ) {
					parent.removeClass( 'redux-field-init' );
				} else {
					return;
				}

				const template = _.template( el.find( '.redparts-vehicle-field-template' ).html() );

				el.find( '.redparts-vehicle-fields' ).sortable( {
					handle: '.redparts-vehicle-fields__item-handle',
					placeholder: 'redparts-vehicle-fields__item redparts-vehicle-fields__item--placeholder',
					forcePlaceholderSize: true,
				} );
				el.find( '.redparts-vehicle-field-add' ).on( 'click', function() {
					let lastIndex = 0;

					el.find( '.redparts-vehicle-fields__item' ).each( function( index, element ) {
						lastIndex = Math.max( lastIndex, parseFloat( $( element ).data( 'index' ) ) );
					} );

					el.find( '.redparts-vehicle-fields' ).append( template( { index: lastIndex + 1 } ) );
				} );
				el.on( 'click', '.redparts-vehicle-field-remove', function() {
					// eslint-disable-next-line no-alert
					if ( confirm( $( this ).data( 'confirm' ) ) ) {
						$( this ).parents( '.redparts-vehicle-fields__item' ).remove();
					}
				} );
			}
		);
	};
}( jQuery ) );
