<?php
/**
 * This file contains code relate to redux vehicle fields.
 *
 * @package RedParts\Sputnik
 * @since 1.2.0
 */

namespace RedParts\Sputnik\Redux\Vehicle_Import_Export;

use RedParts\Sputnik\Plugin;
use Redux_Field;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Redux\Vehicle_Import_Export\Vehicle_Import_Export' ) && class_exists( 'Redux_Field' ) ) {
	/**
	 * Class Admin
	 */
	class Vehicle_Import_Export extends Redux_Field {
		/**
		 * Set field and value defaults.
		 */
		public function set_defaults() {
			$this->value = is_array( $this->value ) ? $this->value : array();
		}

		/**
		 * Outputs field.
		 */
		public function render() {
			?>
			<div class="redparts-export" data-state="start" data-limit="500">
				<div class="redparts-export__start">
					<div>
						<label>
							<input type="checkbox" class="redparts-export__include-compatibility">
							<?php echo esc_html__( 'Include compatibility information', 'redparts-sputnik' ); ?>
						</label>
					</div>

					<button
						type="button"
						class="button redparts-export__button-start"
						data-ajax-url="<?php echo esc_attr( apply_filters( 'redparts_sputnik_ajax_url', '' ) ); ?>"
						data-nonce="<?php echo esc_attr( wp_create_nonce( 'redparts_sputnik_vehicles_export' ) ); ?>"
					>
						<?php echo esc_html__( 'Export', 'redparts-sputnik' ); ?>
					</button>
				</div>
				<div class="redparts-export__progress">
					<p>
						<?php echo esc_html__( 'Export in progress...', 'redparts-sputnik' ); ?>
					</p>

					<div class="redparts-progress-bar">
						<div class="redparts-progress-bar__value"></div>
						<div class="redparts-progress-bar__text"></div>
					</div>

					<button
						type="button"
						class="button redparts-export__button-cancel"
					>
						<?php echo esc_html__( 'Cancel', 'redparts-sputnik' ); ?>
					</button>
				</div>
				<div class="redparts-export__complete">
					<p>
						<a
							href=""
							download="vehicles.csv"
							class="redparts-export__download-link"
						>
							<?php echo esc_html__( 'Download vehicles.csv', 'redparts-sputnik' ); ?>
						</a>
					</p>

					<button
						type="button"
						class="button redparts-export__button-continue"
					>
						<?php echo esc_html__( 'Continue', 'redparts-sputnik' ); ?>
					</button>
				</div>
				<div class="redparts-export__error">
					<div class="redparts-export__error-message"><p></p></div>

					<button
						type="button"
						class="button redparts-export__button-continue"
					>
						<?php echo esc_html__( 'Continue', 'redparts-sputnik' ); ?>
					</button>
				</div>
			</div>

			<br>
			<hr>
			<br>


			<?php
			$messages = array(
				'file_required' => esc_html__( 'Select the CSV file', 'redparts-sputnik' ),
				// translators: %1$s line number, %2$s log message.
				'log_message'   => esc_html__( 'Line #%1$s: %2$s', 'redparts-sputnik' ),
				'confirm_clear' => esc_html__( 'Are you sure you want to delete all vehicles and compatibility data before import?', 'redparts-sputnik' ),
			);
			?>
			<div
				class="redparts-import"
				data-state="start"
				data-messages="<?php echo esc_attr( wp_json_encode( $messages ) ); ?>"
				data-limit="100"
			>
				<pre class="redparts-import__log"></pre>
				<div class="redparts-import__start">
					<div>
						<input type="file" class="redparts-import__file" accept=".csv">
					</div>
					<div>
						<label>
							<input type="checkbox" class="redparts-import__clear">
							<?php echo esc_html__( 'Clear existing data before import', 'redparts-sputnik' ); ?>
						</label>
					</div>

					<button
						type="button"
						class="button redparts-import__button-start"
						data-ajax-url="<?php echo esc_attr( apply_filters( 'redparts_sputnik_ajax_url', '' ) ); ?>"
						data-nonce="<?php echo esc_attr( wp_create_nonce( 'redparts_sputnik_vehicles_import' ) ); ?>"
						data-clear-nonce="<?php echo esc_attr( wp_create_nonce( 'redparts_sputnik_vehicles_clear' ) ); ?>"
					>
						<?php echo esc_html__( 'Import', 'redparts-sputnik' ); ?>
					</button>
				</div>
				<div class="redparts-import__progress" data-type="import">
					<p class="redparts-import__progress-import">
						<?php echo esc_html__( 'Import in progress...', 'redparts-sputnik' ); ?>
					</p>
					<p class="redparts-import__progress-clear">
						<?php echo esc_html__( 'Clear data in progress...', 'redparts-sputnik' ); ?>
					</p>

					<div class="redparts-progress-bar">
						<div class="redparts-progress-bar__value"></div>
						<div class="redparts-progress-bar__text"></div>
					</div>

					<button
						type="button"
						class="button redparts-import__button-cancel"
					>
						<?php echo esc_html__( 'Cancel', 'redparts-sputnik' ); ?>
					</button>
				</div>
				<div class="redparts-import__complete">
					<p>
						<?php echo esc_html__( 'Import completed successfully.', 'redparts-sputnik' ); ?>
					</p>

					<button
						type="button"
						class="button redparts-import__button-continue"
					>
						<?php echo esc_html__( 'Continue', 'redparts-sputnik' ); ?>
					</button>
				</div>
				<div class="redparts-import__error">
					<div class="redparts-import__error-message"><p></p></div>

					<button
						type="button"
						class="button redparts-import__button-continue"
					>
						<?php echo esc_html__( 'Continue', 'redparts-sputnik' ); ?>
					</button>
				</div>
			</div>
			<?php
		}

		/**
		 * Enqueues scripts and styles.
		 */
		public function enqueue() {
			wp_enqueue_style(
				'redparts-sputnik-redux-field-vehicle-import-export-css',
				plugin_dir_url( __FILE__ ) . 'vehicle-import-export.css',
				array(),
				Plugin::VERSION
			);
			wp_enqueue_script(
				'redparts-sputnik-redux-field-vehicle-import-export-js',
				plugin_dir_url( __FILE__ ) . 'vehicle-import-export.js',
				array( 'jquery', 'wp-i18n', 'papaparse', 'js-base64' ),
				Plugin::VERSION,
				true
			);
		}
	}

	class_alias( 'RedParts\Sputnik\Redux\Vehicle_Import_Export\Vehicle_Import_Export', 'Redux_RedParts_Vehicle_Import_Export' );
}
