<?php
/**
 * RedParts SVG Icons.
 *
 * @package RedParts
 * @since 1.0.0
 */

namespace RedParts;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\SVG' ) ) {
	/**
	 * Class SVG
	 */
	class SVG {
		/**
		 * Icons array.
		 *
		 * @var array
		 */
		public static $icons = array(
			'arrow-down-sm-7x5'           => '<svg xmlns="http://www.w3.org/2000/svg" width="7px" height="5px">
	<path d="M0.280,0.282 C0.645,-0.084 1.238,-0.077 1.596,0.297 L3.504,2.310 L5.413,0.297 C5.770,-0.077 6.363,-0.084
             6.728,0.282 C7.080,0.634 7.088,1.203 6.746,1.565 L3.504,5.007 L0.262,1.565 C-0.080,1.203 -0.072,0.634
             0.280,0.282 Z"/>
</svg>',
			'arrow-rounded-down-9x6'      => '<svg xmlns="http://www.w3.org/2000/svg" width="9px" height="6px">
	<path d="M0.2,0.4c0.4-0.4,1-0.5,1.4-0.1l2.9,3l2.9-3c0.4-0.4,1.1-0.4,1.4,0.1c0.3,0.4,0.3,0.9-0.1,1.3L4.5,6L0.3,1.6
             C-0.1,1.3-0.1,0.7,0.2,0.4z"/>
</svg>',
			'arrow-rounded-down-12x7'     => '<svg xmlns="http://www.w3.org/2000/svg" width="12px" height="7px">
	<path d="M0.286,0.273 L0.286,0.273 C-0.070,0.629 -0.075,1.204 0.276,1.565 L5.516,6.993 L10.757,1.565 C11.108,1.204 11.103,0.629 10.747,0.273 L10.747,0.273 C10.385,-0.089 9.796,-0.086 9.437,0.279 L5.516,4.296 L1.596,0.279 C1.237,-0.086 0.648,-0.089 0.286,0.273 Z"/>
</svg>',
			'arrow-rounded-left-7x11'     => '<svg xmlns="http://www.w3.org/2000/svg" width="7" height="11">
	<path d="M6.7,0.3L6.7,0.3c-0.4-0.4-0.9-0.4-1.3,0L0,5.5l5.4,5.2c0.4,0.4,0.9,0.3,1.3,0l0,0c0.4-0.4,0.4-1,0-1.3l-4-3.9l4-3.9C7.1,1.2,7.1,0.6,6.7,0.3z"/>
</svg>',
			'arrow-rounded-right-6x9'     => '<svg xmlns="http://www.w3.org/2000/svg" width="6px" height="9px">
	<path d="M0.3,7.4l3-2.9l-3-2.9c-0.4-0.3-0.4-0.9,0-1.3l0,0c0.4-0.3,0.9-0.4,1.3,0L6,4.5L1.6,8.7c-0.4,0.4-0.9,0.4-1.3,0l0,0C-0.1,8.4-0.1,7.8,0.3,7.4z"/>
</svg>',
			'arrow-rounded-right-7x11'    => '<svg xmlns="http://www.w3.org/2000/svg" width="7" height="11">
	<path d="M0.3,10.7L0.3,10.7c0.4,0.4,0.9,0.4,1.3,0L7,5.5L1.6,0.3C1.2-0.1,0.7,0,0.3,0.3l0,0c-0.4,0.4-0.4,1,0,1.3l4,3.9l-4,3.9
	C-0.1,9.8-0.1,10.4,0.3,10.7z"/>
</svg>',
			'calendar-16'                 => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
	<path d="M15,14.5c0,0.8-0.7,1.5-1.5,1.5h-11C1.7,16,1,15.3,1,14.5V6h14V14.5z M5,8.5C5,8.2,4.8,8,4.5,8h-1C3.2,8,3,8.2,3,8.5v1C3,9.8,3.2,10,3.5,10h1C4.8,10,5,9.8,5,9.5V8.5z M5,12.5C5,12.2,4.8,12,4.5,12h-1C3.2,12,3,12.2,3,12.5v1C3,13.8,3.2,14,3.5,14h1C4.8,14,5,13.8,5,13.5V12.5z M9,8.5C9,8.2,8.8,8,8.5,8h-1C7.2,8,7,8.2,7,8.5v1C7,9.8,7.2,10,7.5,10h1C8.8,10,9,9.8,9,9.5V8.5zM9,12.5C9,12.2,8.8,12,8.5,12h-1C7.2,12,7,12.2,7,12.5v1C7,13.8,7.2,14,7.5,14h1C8.8,14,9,13.8,9,13.5V12.5z M13,8.5C13,8.2,12.8,8,12.5,8h-1C11.2,8,11,8.2,11,8.5v1c0,0.3,0.2,0.5,0.5,0.5h1c0.3,0,0.5-0.2,0.5-0.5V8.5z M13,12.5c0-0.3-0.2-0.5-0.5-0.5h-1c-0.3,0-0.5,0.2-0.5,0.5v1c0,0.3,0.2,0.5,0.5,0.5h1c0.3,0,0.5-0.2,0.5-0.5V12.5z M1,3.5C1,2.7,1.7,2,2.5,2H4V0.5C4,0.2,4.2,0,4.5,0h1C5.8,0,6,0.2,6,0.5V2h4V0.5C10,0.2,10.2,0,10.5,0h1C11.8,0,12,0.2,12,0.5V2h1.5C14.3,2,15,2.7,15,3.5V5H1V3.5z"/>
</svg>',
			'car-20'                      => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
	<path d="M6.6,2c2,0,4.8,0,6.8,0c1,0,2.9,0.8,3.6,2.2C17.7,5.7,17.9,7,18.4,7C20,7,20,8,20,8v1h-1v7.5c0,0.8-0.7,1.5-1.5,1.5h-1
		c-0.8,0-1.5-0.7-1.5-1.5V16H5v0.5C5,17.3,4.3,18,3.5,18h-1C1.7,18,1,17.3,1,16.5V16V9H0V8c0,0,0.1-1,1.6-1C2.1,7,2.3,5.7,3,4.2
		C3.7,2.8,5.6,2,6.6,2z M13.3,4H6.7c-0.8,0-1.4,0-2,0.7c-0.5,0.6-0.8,1.5-1,2C3.6,7.1,3.5,7.9,3.7,8C4.5,8.4,6.1,9,10,9
		c4,0,5.4-0.6,6.3-1c0.2-0.1,0.2-0.8,0-1.2c-0.2-0.4-0.5-1.5-1-2C14.7,4,14.1,4,13.3,4z M4,10c-0.4-0.3-1.5-0.5-2,0
		c-0.4,0.4-0.4,1.6,0,2c0.5,0.5,4,0.4,4,0C6,11.2,4.5,10.3,4,10z M14,12c0,0.4,3.5,0.5,4,0c0.4-0.4,0.4-1.6,0-2c-0.5-0.5-1.3-0.3-2,0
		C15.5,10.2,14,11.3,14,12z"/>
</svg>',
			'cart-20'                     => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
	<circle cx="7" cy="17" r="2"/>
	<circle cx="15" cy="17" r="2"/>
	<path d="M20,4.4V5l-1.8,6.3c-0.1,0.4-0.5,0.7-1,0.7H6.7c-0.4,0-0.8-0.3-1-0.7L3.3,3.9C3.1,3.3,2.6,3,2.1,3H0.4C0.2,3,0,2.8,0,2.6
		V1.4C0,1.2,0.2,1,0.4,1h2.5c1,0,1.8,0.6,2.1,1.6L5.1,3l2.3,6.8c0,0.1,0.2,0.2,0.3,0.2h8.6c0.1,0,0.3-0.1,0.3-0.2l1.3-4.4
		C17.9,5.2,17.7,5,17.5,5H9.4C9.2,5,9,4.8,9,4.6V3.4C9,3.2,9.2,3,9.4,3h9.2C19.4,3,20,3.6,20,4.4z"/>
</svg>',
			'cart-32'                     => '<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32">
	<circle cx="10.5" cy="27.5" r="2.5"/>
	<circle cx="23.5" cy="27.5" r="2.5"/>
	<path d="M26.4,21H11.2C10,21,9,20.2,8.8,19.1L5.4,4.8C5.3,4.3,4.9,4,4.4,4H1C0.4,4,0,3.6,0,3s0.4-1,1-1h3.4C5.8,2,7,3,7.3,4.3
		l3.4,14.3c0.1,0.2,0.3,0.4,0.5,0.4h15.2c0.2,0,0.4-0.1,0.5-0.4l3.1-10c0.1-0.2,0-0.4-0.1-0.4C29.8,8.1,29.7,8,29.5,8H14
		c-0.6,0-1-0.4-1-1s0.4-1,1-1h15.5c0.8,0,1.5,0.4,2,1c0.5,0.6,0.6,1.5,0.4,2.2l-3.1,10C28.5,20.3,27.5,21,26.4,21z"/>
</svg>',
			'category-20'                 => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
	<path d="M6.5,16.5v-1h12v1H6.5z M1.5,16.5v-1h1v1H1.5z M6.5,10.5v-1h12v1H6.5z M1.5,10.5v-1h1v1H1.5z M6.5,4.5v-1h12v1
		H6.5z M1.5,4.5v-1h1v1H1.5z"/>
	<path d="M19,3H6v2h13V3L19,3z M3,3H1v2h2V3L3,3z M19,9H6v2h13V9L19,9z M3,9H1v2h2V9L3,9z M19,15H6v2h13V15L19,15z M3,15H1v2h2V15
		L3,15z"/>
</svg>',
			'check-16'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M16,4.5l-9.5,9.4L1.1,8.4l1.7-1.7l3.7,3.5l7.7-7.6L16,4.5z"></path>
</svg>',
			'comment-16'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
	<path d="M16,7.9c-0.1,3.6-5.4,7.5-11.4,5.5c-1,0.8-2.4,1.5-4.2,1.6c-0.3,0-0.6-0.2-0.3-0.4c0.6-0.6,1.4-1.8,1.7-3C-0.9,9.2-1.1,3.5,5.4,1.4C9.1,0.1,16.2,1.9,16,7.9z"/>
</svg>',
			'compare-16'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
    <path d="M9,15H7c-0.6,0-1-0.4-1-1V2c0-0.6,0.4-1,1-1h2c0.6,0,1,0.4,1,1v12C10,14.6,9.6,15,9,15z"/>
    <path d="M1,9h2c0.6,0,1,0.4,1,1v4c0,0.6-0.4,1-1,1H1c-0.6,0-1-0.4-1-1v-4C0,9.4,0.4,9,1,9z"/>
    <path d="M15,5h-2c-0.6,0-1,0.4-1,1v8c0,0.6,0.4,1,1,1h2c0.6,0,1-0.4,1-1V6C16,5.4,15.6,5,15,5z"/>
</svg>',
			'cross-12'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12">
<path d="M10.8,10.8L10.8,10.8c-0.4,0.4-1,0.4-1.4,0L6,7.4l-3.4,3.4c-0.4,0.4-1,0.4-1.4,0l0,0c-0.4-0.4-0.4-1,0-1.4L4.6,6L1.2,2.6
	c-0.4-0.4-0.4-1,0-1.4l0,0c0.4-0.4,1-0.4,1.4,0L6,4.6l3.4-3.4c0.4-0.4,1-0.4,1.4,0l0,0c0.4,0.4,0.4,1,0,1.4L7.4,6l3.4,3.4
	C11.2,9.8,11.2,10.4,10.8,10.8z"/>
</svg>',
			'cross-20'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
	<path d="M16.7,16.7L16.7,16.7c-0.4,0.4-1,0.4-1.4,0L10,11.4l-5.3,5.3c-0.4,0.4-1,0.4-1.4,0l0,0c-0.4-0.4-0.4-1,0-1.4L8.6,10L3.3,4.7
		c-0.4-0.4-0.4-1,0-1.4l0,0c0.4-0.4,1-0.4,1.4,0L10,8.6l5.3-5.3c0.4-0.4,1-0.4,1.4,0l0,0c0.4,0.4,0.4,1,0,1.4L11.4,10l5.3,5.3
		C17.1,15.7,17.1,16.3,16.7,16.7z"/>
</svg>',
			'filters-16'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M7,14v-2h9v2H7z M14,7h2v2h-2V7z M12.5,6C12.8,6,13,6.2,13,6.5v3c0,0.3-0.2,0.5-0.5,0.5h-2
	C10.2,10,10,9.8,10,9.5v-3C10,6.2,10.2,6,10.5,6H12.5z M7,2h9v2H7V2z M5.5,5h-2C3.2,5,3,4.8,3,4.5v-3C3,1.2,3.2,1,3.5,1h2
	C5.8,1,6,1.2,6,1.5v3C6,4.8,5.8,5,5.5,5z M0,2h2v2H0V2z M9,9H0V7h9V9z M2,14H0v-2h2V14z M3.5,11h2C5.8,11,6,11.2,6,11.5v3
	C6,14.8,5.8,15,5.5,15h-2C3.2,15,3,14.8,3,14.5v-3C3,11.2,3.2,11,3.5,11z"/>
</svg>',
			'heart-20'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
<path d="M14,3c2.2,0,4,1.8,4,4c0,4-5.2,10-8,10S2,11,2,7c0-2.2,1.8-4,4-4c1,0,1.9,0.4,2.7,1L10,5.2L11.3,4C12.1,3.4,13,3,14,3 M14,1
	c-1.5,0-2.9,0.6-4,1.5C8.9,1.6,7.5,1,6,1C2.7,1,0,3.7,0,7c0,5,6,12,10,12s10-7,10-12C20,3.7,17.3,1,14,1L14,1z"/>
</svg>',
			'heart-32'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32">
	<path d="M23,4c3.9,0,7,3.1,7,7c0,6.3-11.4,15.9-14,16.9C13.4,26.9,2,17.3,2,11c0-3.9,3.1-7,7-7c2.1,0,4.1,1,5.4,2.6l1.6,2l1.6-2
		C18.9,5,20.9,4,23,4 M23,2c-2.8,0-5.4,1.3-7,3.4C14.4,3.3,11.8,2,9,2c-5,0-9,4-9,9c0,8,14,19,16,19s16-11,16-19C32,6,28,2,23,2L23,2
		z"/>
</svg>',
			'layout-grid-16'              => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M15.2,16H9.8C9.4,16,9,15.6,9,15.2V9.8C9,9.4,9.4,9,9.8,9h5.4C15.6,9,16,9.4,16,9.8v5.4C16,15.6,15.6,16,15.2,16z M15.2,7
	H9.8C9.4,7,9,6.6,9,6.2V0.8C9,0.4,9.4,0,9.8,0h5.4C15.6,0,16,0.4,16,0.8v5.4C16,6.6,15.6,7,15.2,7z M6.2,16H0.8
	C0.4,16,0,15.6,0,15.2V9.8C0,9.4,0.4,9,0.8,9h5.4C6.6,9,7,9.4,7,9.8v5.4C7,15.6,6.6,16,6.2,16z M6.2,7H0.8C0.4,7,0,6.6,0,6.2V0.8
	C0,0.4,0.4,0,0.8,0h5.4C6.6,0,7,0.4,7,0.8v5.4C7,6.6,6.6,7,6.2,7z"/>
</svg>',
			'layout-grid-with-details-16' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M16,0.8v14.4c0,0.4-0.4,0.8-0.8,0.8H9.8C9.4,16,9,15.6,9,15.2V0.8C9,0.4,9.4,0,9.8,0l5.4,0C15.6,0,16,0.4,16,0.8z M7,0.8
	v14.4C7,15.6,6.6,16,6.2,16H0.8C0.4,16,0,15.6,0,15.2L0,0.8C0,0.4,0.4,0,0.8,0l5.4,0C6.6,0,7,0.4,7,0.8z"/>
</svg>',
			'layout-list-16'              => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M15.2,16H0.8C0.4,16,0,15.6,0,15.2V9.8C0,9.4,0.4,9,0.8,9h14.4C15.6,9,16,9.4,16,9.8v5.4C16,15.6,15.6,16,15.2,16z M15.2,7
	H0.8C0.4,7,0,6.6,0,6.2V0.8C0,0.4,0.4,0,0.8,0h14.4C15.6,0,16,0.4,16,0.8v5.4C16,6.6,15.6,7,15.2,7z"/>
</svg>',
			'layout-table-16'             => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M15.2,16H0.8C0.4,16,0,15.6,0,15.2v-2.4C0,12.4,0.4,12,0.8,12h14.4c0.4,0,0.8,0.4,0.8,0.8v2.4C16,15.6,15.6,16,15.2,16z
	 M15.2,10H0.8C0.4,10,0,9.6,0,9.2V6.8C0,6.4,0.4,6,0.8,6h14.4C15.6,6,16,6.4,16,6.8v2.4C16,9.6,15.6,10,15.2,10z M15.2,4H0.8
	C0.4,4,0,3.6,0,3.2V0.8C0,0.4,0.4,0,0.8,0h14.4C15.6,0,16,0.4,16,0.8v2.4C16,3.6,15.6,4,15.2,4z"/>
</svg>',
			'menu-16x12'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="16px" height="12px">
	<path d="M0,7L0,5L16,5L16,7L0,7ZM0,0L16,0L16,2L0,2L0,0ZM12,12L0,12L0,10L12,10L12,12Z"/>
</svg>',
			'menu-18x14'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="18px" height="14px">
    <path d="M-0,8L-0,6L18,6L18,8L-0,8ZM-0,-0L18,-0L18,2L-0,2L-0,-0ZM14,14L-0,14L-0,12L14,12L14,14Z"/>
</svg>',
			'person-20'                   => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
	<path d="M20,20h-2c0-4.4-3.6-8-8-8s-8,3.6-8,8H0c0-4.2,2.6-7.8,6.3-9.3C4.9,9.6,4,7.9,4,6c0-3.3,2.7-6,6-6s6,2.7,6,6
		c0,1.9-0.9,3.6-2.3,4.7C17.4,12.2,20,15.8,20,20z M14,6c0-2.2-1.8-4-4-4S6,3.8,6,6s1.8,4,4,4S14,8.2,14,6z"/>
</svg>',
			'person-32'                   => '<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32">
	<path d="M16,18C9.4,18,4,23.4,4,30H2c0-6.2,4-11.5,9.6-13.3C9.4,15.3,8,12.8,8,10c0-4.4,3.6-8,8-8s8,3.6,8,8c0,2.8-1.5,5.3-3.6,6.7
		C26,18.5,30,23.8,30,30h-2C28,23.4,22.6,18,16,18z M22,10c0-3.3-2.7-6-6-6s-6,2.7-6,6s2.7,6,6,6S22,13.3,22,10z"/>
</svg>',
			'quickview-16'                => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M14,15h-4v-2h3v-3h2v4C15,14.6,14.6,15,14,15z M13,3h-3V1h4c0.6,0,1,0.4,1,1v4h-2V3z M6,3H3v3H1V2c0-0.6,0.4-1,1-1h4V3z
	 M3,13h3v2H2c-0.6,0-1-0.4-1-1v-4h2V13z"/>
</svg>',
			'search-20'                   => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
	<path d="M19.2,17.8c0,0-0.2,0.5-0.5,0.8c-0.4,0.4-0.9,0.6-0.9,0.6s-0.9,0.7-2.8-1.6c-1.1-1.4-2.2-2.8-3.1-3.9C10.9,14.5,9.5,15,8,15
		c-3.9,0-7-3.1-7-7s3.1-7,7-7s7,3.1,7,7c0,1.5-0.5,2.9-1.3,4c1.1,0.8,2.5,2,4,3.1C20,16.8,19.2,17.8,19.2,17.8z M8,3C5.2,3,3,5.2,3,8
		c0,2.8,2.2,5,5,5c2.8,0,5-2.2,5-5C13,5.2,10.8,3,8,3z"/>
</svg>',
			'wishlist-16'                 => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
<path d="M13.9,8.4l-5.4,5.4c-0.3,0.3-0.7,0.3-1,0L2.1,8.4c-1.5-1.5-1.5-3.8,0-5.3C2.8,2.4,3.8,2,4.8,2s1.9,0.4,2.6,1.1L8,3.7
	l0.6-0.6C9.3,2.4,10.3,2,11.3,2c1,0,1.9,0.4,2.6,1.1C15.4,4.6,15.4,6.9,13.9,8.4z"/>
</svg>',
			'zoom-24'                     => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24">
<path d="M15,18c-2,0-3.8-0.6-5.2-1.7c-1,1.3-2.1,2.8-3.5,4.6c-2.2,2.8-3.4,1.9-3.4,1.9s-0.6-0.3-1.1-0.7
	c-0.4-0.4-0.7-1-0.7-1s-0.9-1.2,1.9-3.3c1.8-1.4,3.3-2.5,4.6-3.5C6.6,12.8,6,11,6,9c0-5,4-9,9-9s9,4,9,9S20,18,15,18z M15,2
	c-3.9,0-7,3.1-7,7s3.1,7,7,7s7-3.1,7-7S18.9,2,15,2z M16,13h-2v-3h-3V8h3V5h2v3h3v2h-3V13z"/>
</svg>',
		);

		/**
		 * Returns SVG icon.
		 *
		 * @param string $name    Icon name.
		 * @param string $classes CSS classes.
		 *
		 * @return string
		 */
		public static function get( string $name, $classes = '' ): string {
			if ( ! array_key_exists( $name, self::$icons ) ) {
				return '';
			}

			$classes = trim( $classes );
			$icon    = trim( self::$icons[ $name ] );

			if ( $classes ) {
				$icon = preg_replace( '/^<svg\s+/', '<svg class="' . esc_attr( $classes ) . '" ', $icon );
			}

			$icon = apply_filters( 'redparts_get_icon', $icon, $name, $classes );

			return wp_kses(
				$icon,
				apply_filters(
					'redparts_svg_allowed_html',
					array(
						'svg'    => array(
							'class'  => true,
							'xmlns'  => true,
							'width'  => true,
							'height' => true,
						),
						'path'   => array(
							'd' => true,
						),
						'circle' => array(
							'cx' => true,
							'cy' => true,
							'r'  => true,
						),
					)
				)
			);
		}
	}
}
