jQuery(document).ready(function ($) {
	var order_id = phpVars.order_id;
	var generate_label_params = phpVars.generate_label_params;
	var product_weight_tot = phpVars.product_weight;
	var ajax_url = phpVars.ajax_url;

	var $button = $('button[name="package_label_seller"]');
	var originalText = $button.text();

	window.generate_label_seller = function () {
		var pweight = jQuery("#weight_dokan").val();
		var plength = jQuery("#product_length_dokan").val();
		var pwidth = jQuery("#product_width_dokan").val();
		var pheight = jQuery("#product_height_dokan").val();

		var max_gross_weight = phpVars.max_gross_weight;
		var max_length = phpVars.max_length;
		var max_width = phpVars.max_width;
		var max_height = phpVars.max_height;

		$(".error-message").empty();
		function validateData(data) {
			let errors = [];

			function validateSection(section, sectionName) {
				if (!section.name.trim()) {
					errors.push(`${sectionName} - Name is required.`);
				}
				if (!section.addressLine1.trim()) {
					errors.push(`${sectionName} - Address 1 is required.`);
				}
				if (!section.stateOrRegion.trim()) {
					errors.push(`${sectionName} - state is required.`);
				}
				if (!section.city.trim()) {
					errors.push(`${sectionName} - City is required.`);
				}
				if (!section.countryCode.trim()) {
					errors.push(`${sectionName} - Country is required.`);
				}
				if (!section.postalCode.trim()) {
					errors.push(`${sectionName} - Post Code is required.`);
				}
			}

			validateSection(data.shipTo, "Shipping");
			validateSection(data.shipFrom, "Seller");
			validateSection(data.returnTo, "Seller");

			// Validate each item in packages
			data.packages.forEach((package, index) => {
				package.items.forEach((item, itemIndex) => {
					if (!item.description.trim()) {
						errors.push(`Product - Description is required.`);
					}
					if (item.itemValue.value <= 0) {
						errors.push(`Order - Total must be greater than zero.`);
					}
					if (
						!item.itemValue.unit ||
						typeof item.itemValue.unit !== "string" ||
						item.itemValue.unit.trim() === ""
					) {
						errors.push(`Order - Unit is required and must be a valid string.`);
					}
					if (item.quantity <= 0) {
						errors.push(`Item - Quantity must be greater than zero.`);
					}
				});

				if (package.insuredValue.value >= 50000) {
					errors.push(`Total order value should be less than 50000`);
				}
			});

			if (pweight === "") {
				$("#errMsgWeightDokan").text("Package weight is required.");
			} else if (parseFloat(pweight) <= 0) {
				$("#errMsgWeightDokan").text(
					"Package weight should not be less than or equal to zero."
				);
			} else if (parseFloat(pweight) < parseFloat(product_weight_tot)) {
				$("#errMsgWeightDokan").text(
					"Package gross weight should be greater than order gross weight."
				);
			} else if (parseFloat(pweight) > parseFloat(max_gross_weight)) {
				$("#errMsgWeightDokan").text(
					"Package gross weight should be less than 18000."
				);
			}

			if (plength === "") {
				$("#errMsgLengthDokan").text("Package length is required.");
			} else if (parseFloat(plength) <= 0) {
				$("#errMsgLengthDokan").text(
					"Package length should not be less than or equal to zero."
				);
			} else if (parseFloat(plength) > parseFloat(max_length)) {
				$("#errMsgLengthDokan").text("Package length should be less than 70.");
			}

			if (pwidth === "") {
				$("#errMsgWidthDokan").text("Package width is required.");
			} else if (parseFloat(pwidth) <= 0) {
				$("#errMsgWidthDokan").text(
					"Package width should not be less than or equal to zero."
				);
			} else if (parseFloat(pwidth) > parseFloat(max_width)) {
				$("#errMsgWidthDokan").text("Package width should be less than 70.");
			}

			if (pheight === "") {
				$("#errMsgHeightDokan").text("Package height is required.");
			} else if (parseFloat(pheight) <= 0) {
				$("#errMsgHeightDokan").text(
					"Package height should not be less than or equal to zero."
				);
			} else if (parseFloat(pheight) > parseFloat(max_height)) {
				$("#errMsgHeightDokan").text("Package height should be less than 45.");
			}

			if ($("#errMsgWeightDokan").text()) {
				errors.push($("#errMsgWeightDokan").text());
			}
			if ($("#errMsgLengthDokan").text()) {
				errors.push($("#errMsgLengthDokan").text());
			}
			if ($("#errMsgWidthDokan").text()) {
				errors.push($("#errMsgWidthDokan").text());
			}
			if ($("#errMsgHeightDokan").text()) {
				errors.push($("#errMsgHeightDokan").text());
			}

			return errors;
		}

		// Perform validation
		let errors = validateData(generate_label_params);

		if (errors.length > 0) {
			$("#dokan-panel-div").prepend(
				"<ul>" +
					errors
						.filter(
							(error) =>
								!$("#errMsgWeightDokan").text().includes(error) &&
								!$("#errMsgLengthDokan").text().includes(error) &&
								!$("#errMsgWidthDokan").text().includes(error) &&
								!$("#errMsgHeightDokan").text().includes(error)
						)
						.map((error) => '<li class="error-message">' + error + "</li>")
						.join("") +
					"</ul>"
			);
		} else {
			$button.prop("disabled", true).html("Please Wait...");
			$(".error-message").empty();
			product_data = {
				product_weight: pweight,
				product_length: plength,
				product_width: pwidth,
				product_height: pheight,
			};
			$.ajax({
				type: "POST",
				url: ajax_url,
				dataType: "json",
				cache: false,
				data: {
					action: "ajax_generate_label",
					order_id: order_id,
					product_data: product_data,
					label_action: "generate_label",
				},
				success: function (result) {
					console.log(result);
					if (result.success) {
						$(".error-message").empty();
						$("#awb_number_seller").html(
							"<span>AWB Number:</span> <span><strong>" +
								result.data.tracking_id +
								"</strong></span>"
						);
						$("#package_label_pdf_seller_div").html(
							'<strong><a class="blue-color" download id="package-label-link" href="' +
								result.data.pdf_url +
								'">Download Label</a></strong>'
						);
						$button.prop("disabled", true).html(originalText);
						// Asynchronously send the email
						send_email_async_dokan(order_id, result.data.email_data);
						location.reload();
					} else {
						$button.prop("disabled", false).html(originalText);
						$(".error-message").empty();
						$("#dokan-panel-div").prepend(
							'<span class="error-message"><strong>' +
								result.data.message +
								" " +
								result.data.detail_error_message +
								"</strong></span>"
						);
					}
				},
				error: function (error) {
					console.log("Error:", error);
					$button.prop("disabled", false).html(originalText);
				},
			});
		}
	};

	// Send email asynchronously
	function send_email_async_dokan(order_id, email_data) {
		$.ajax({
			type: "POST",
			url: ajax_url,
			dataType: "json",
			cache: false,
			data: {
				action: "send_email_async",
				order_id: order_id,
				email_data: email_data,
			},
			success: function (response) {
				console.log("Email sent:", response);
			},
			error: function (error) {
				console.log("Email sending failed:", error);
			},
		});
	}
});
