jQuery(document).ready(function ($) {
	$(".tip-title").tipTip();
	var order_id = phpVars.order_id;
	var generate_label_params = phpVars.generate_label_params;
	var product_weight_tot = phpVars.product_weight;
	var ajax_url = phpVars.ajax_url;

	var max_gross_weight = phpVars.max_gross_weight;
	var max_length = phpVars.max_length;
	var max_width = phpVars.max_width;
	var max_height = phpVars.max_height;

	window.generate_label = function () {
		var pweight = $("#auroship_weight").val().trim();
		var plength = $("#auroship_product_length").val().trim();
		var pwidth = $("#auroship_product_width").val().trim();
		var pheight = $("#auroship_product_height").val().trim();
		$(".error-message").empty();
		function validateData(data) {
			let errors = [];

			function validateSection(section, sectionName) {
				if (!section.name.trim()) {
					errors.push(`${sectionName} - Name is required.`);
				}
				if (!section.addressLine1.trim()) {
					errors.push(`${sectionName} - Address 1 is required.`);
				}
				if (!section.stateOrRegion.trim()) {
					errors.push(`${sectionName} - state is required.`);
				}
				if (!section.city.trim()) {
					errors.push(`${sectionName} - City is required.`);
				}
				if (!section.countryCode.trim()) {
					errors.push(`${sectionName} - Country is required.`);
				}
				if (!section.postalCode.trim()) {
					errors.push(`${sectionName} - Post Code is required.`);
				}
			}

			validateSection(data.shipTo, "Shipping");
			validateSection(data.shipFrom, "Seller");
			validateSection(data.returnTo, "Seller");

			// Validate each item in packages
			data.packages.forEach((package, index) => {
				package.items.forEach((item, itemIndex) => {
					if (!item.description.trim()) {
						errors.push(`Product - Name is required.`);
					}
					if (item.itemValue.value <= 0) {
						errors.push(`Order - Total must be greater than zero.`);
					}
					if (
						!item.itemValue.unit ||
						typeof item.itemValue.unit !== "string" ||
						item.itemValue.unit.trim() === ""
					) {
						errors.push(`Order - Unit is required and must be a valid string.`);
					}
					if (item.quantity <= 0) {
						errors.push(`Item - Quantity must be greater than zero.`);
					}
				});

				if (package.insuredValue.value >= 50000) {
					errors.push(`Total order value should be less than 50000.`);
				}
			});

			if (pweight === "") {
				$("#errMsgWeight").text("Package weight is required.");
			} else if (parseFloat(pweight) <= 0) {
				$("#errMsgWeight").text(
					"Package weight should not be less than or equal to zero."
				);
			} else if (parseFloat(pweight) < parseFloat(product_weight_tot)) {
				$("#errMsgWeight").text(
					"Package gross weight should be greater than order gross weight."
				);
			} else if (parseFloat(pweight) > parseFloat(max_gross_weight)) {
				$("#errMsgWeight").text(
					"Package gross weight should be less than 18000."
				);
			}

			if (plength === "") {
				$("#errMsgLength").text("Package length is required.");
			} else if (parseFloat(plength) <= 0) {
				$("#errMsgLength").text(
					"Package length should not be less than or equal to zero."
				);
			} else if (parseFloat(plength) > parseFloat(max_length)) {
				$("#errMsgLength").text("Package length should be less than 70.");
			}

			if (pwidth === "") {
				$("#errMsgWidth").text("Package width is required.");
			} else if (parseFloat(pwidth) <= 0) {
				$("#errMsgWidth").text(
					"Package width should not be less than or equal to zero."
				);
			} else if (parseFloat(pwidth) > parseFloat(max_width)) {
				$("#errMsgWidth").text("Package width should be less than 70.");
			}

			if (pheight === "") {
				$("#errMsgHeight").text("Package height is required.");
			} else if (parseFloat(pheight) <= 0) {
				$("#errMsgHeight").text(
					"Package height should not be less than or equal to zero."
				);
			} else if (parseFloat(pheight) > parseFloat(max_height)) {
				$("#errMsgHeight").text("Package height should be less than 45.");
			}

			if ($("#errMsgWeight").text()) {
				errors.push($("#errMsgWeight").text());
			}
			if ($("#errMsgLength").text()) {
				errors.push($("#errMsgLength").text());
			}
			if ($("#errMsgWidth").text()) {
				errors.push($("#errMsgWidth").text());
			}
			if ($("#errMsgHeight").text()) {
				errors.push($("#errMsgHeight").text());
			}

			return errors;
		}

		// Perform validation
		let errors = validateData(generate_label_params);

		if (errors.length > 0) {
			$("#postbox-container-1").prepend(
				"<ul>" +
					errors
						.filter(
							(error) =>
								!$("#errMsgWeight").text().includes(error) &&
								!$("#errMsgLength").text().includes(error) &&
								!$("#errMsgWidth").text().includes(error) &&
								!$("#errMsgHeight").text().includes(error)
						)
						.map((error) => '<li class="error-message">' + error + "</li>")
						.join("") +
					"</ul>"
			);
		} else {
			var $button = $('button[name="package_label"]');
			var originalText = $button.text();
			$button.prop("disabled", true).html("Please Wait...");
			$(".error-message").empty();
			product_data = {
				product_weight: pweight,
				product_length: plength,
				product_width: pwidth,
				product_height: pheight,
			};
			$.ajax({
				type: "POST",
				url: ajax_url,
				dataType: "json",
				cache: false,
				data: {
					action: "ajax_generate_label",
					order_id: order_id,
					product_data: product_data,
					label_action: "generate_label",
				},
				success: function (result) {
					console.log(result);
					if (result.success) {
						$(".error-message").empty();
						$("#awb_number").html(
							"<span>AWB Number:</span> <span><strong>" +
								result.data.tracking_id +
								"</strong></span>"
						);
						$("#package_label_pdf_div").html(
							'<strong><a download id="package-label-link" href="' +
								result.data.pdf_url +
								'">Download Label</a></strong>'
						);
						$button.prop("disabled", false).html("Re-generate Label");

						// Asynchronously send the email
						sendEmailAsync(order_id, result.data.email_data);
						location.reload();
					} else {
						$button.prop("disabled", false).html(originalText);
						$(".error-message").empty();
						$("#postbox-container-1").prepend(
							'<span class="error-message"><strong>' +
								result.data.message +
								" " +
								result.data.detail_error_message +
								"</strong></span>"
						);
					}
				},
				error: function (error) {
					console.log("Error:", error);
					$button.prop("disabled", false).html(originalText);
				},
			});
		}
	};

	// Send email asynchronously
	function sendEmailAsync(order_id, email_data) {
		$.ajax({
			type: "POST",
			url: ajax_url,
			dataType: "json",
			cache: false,
			data: {
				action: "send_email_async",
				order_id: order_id,
				email_data: email_data,
			},
			success: function (response) {
				console.log("Email sent:", response);
			},
			error: function (error) {
				console.log("Email sending failed:", error);
			},
		});
	}
});
