jQuery(document).ready(function ($) {
	const order_id = phpVariables.order_id;
	const ajax_url = phpVariables.ajax_url;

	window.tracking_shipment_dokan = function () {
		var tracking_awb_number = $("#tracking_awb_number_dokan").val().trim();
		var shipping_provider = $("#shipping_provider_dokan").val().trim();

		$(".error-message").empty();
		jQuery("#errMsgTrackNumberDokan").text("");
		jQuery("#errMsgShippingProviderDokan").text("");

		let hasError = false;

		if (tracking_awb_number === "") {
			jQuery("#errMsgTrackNumberDokan").text(
				"AWB Number is missing or not found."
			);
			jQuery("#tracking_awb_number_dokan").focus();
			hasError = true;
		}

		if (shipping_provider === "") {
			jQuery("#errMsgShippingProviderDokan").text(
				"Shipping provider is missing or not found."
			);
			if (!hasError) {
				jQuery("#shipping_provider_dokan").focus();
			}
			hasError = true;
		}

		if (hasError) {
			return false;
		} else {
			var $button = $('button[name="tracking_btn_dokan"]');
			var originalText = $button.text();
			$button.prop("disabled", true).html("Please Wait...");
			$(".error-message").empty();

			$.ajax({
				type: "POST",
				url: ajax_url,
				dataType: "json",
				cache: false,
				data: {
					action: "ajax_tracking_shipment",
					order_id: order_id,
					tracking_action: "tracking_shipment",
				},
				success: function (result) {
					$button.prop("disabled", false).html(originalText);
					console.log(result);
					if (result.success) {
						$(".error-message").empty();
						$(".tracking-details").html("");

						var specific_statuses = [
							"PickupCancelled",
							"ReturnInitiated",
							"Rejected",
							"Undeliverable",
							"Lost",
							"Delivered",
						];

						var shipping_status = result.data.shipping_data.shipping_status;
						var html = `
    <ul class="list-unstyled">
        <li>
            <span for="tracking_details"><strong>Tracking Details: </strong></span>
        </li>
        <li>
            <span for="shipping_status_dokan">Current Status: </span>
            <span class="no-bold" id="shipping_status_dokan">${shipping_status}</span>
        </li>`;

						if (!specific_statuses.includes(shipping_status)) {
							html += `<li>
            <span for="estimated_delivery_date_dokan">Estimated Delivery: </span>
            <span class="no-bold" id="estimated_delivery_date_dokan">${result.data.shipping_data.estimated_delivery_date}</span>
        </li>`;
						}

						html += `</ul>
    <br>
    <ul class="list-unstyled">
        <li>
            <span for="tracking_history"><strong>Tracking History: </strong></span>
        </li>
        <div id="tracking-container-dokan">`;

						// Parse the JSON string into a JavaScript object
						var tracking_history_arr = JSON.parse(
							result.data.shipping_data.tracking_history
						);

						var tracking_event_code = [
							"ReadyForReceive",
							"PickupDone",
							"Delivered",
							"Departed",
							"DeliveryAttempted",
							"Lost",
							"OutForDelivery",
							"ArrivedAtCarrierFacility",
							"Rejected",
							"Undeliverable",
							"PickupCancelled",
							"ReturnInitiated",
							"AvailableForPickup",
						];

						// Loop through each tracking event code
						$.each(tracking_event_code, function (index, event_code) {
							if (tracking_history_arr.payload) {
								$.each(
									tracking_history_arr.payload.eventHistory,
									function (i, event_history) {
										if (event_history.eventCode === event_code) {
											var formateddate = new Date(event_history.eventTime);
											var event_date =
												formateddate.getDate().toString().padStart(2, "0") +
												"-" +
												(formateddate.getMonth() + 1)
													.toString()
													.padStart(2, "0") +
												"-" +
												formateddate.getFullYear();

											html +=
												'<li><label for="tracking_awb_number_dokan">' +
												event_code +
												":</label> ";
											html +=
												'<span class="no-bold">' + event_date + "</span></li>";
											return false; // Break the inner loop
										}
									}
								);
							}
						});

						html += "</div></ul></div>";
						$(".tracking-details").html(html);

						if (result.data.email_data) {
							// Asynchronously send the email
							sendEmailTrackingAsyncDokan(order_id, result.data.email_data);
						}
						location.reload();
					} else {
						$button.prop("disabled", false).html(originalText);
						$(".error-message").empty();
						$("#postbox-container-1").prepend(
							'<span class="no-bold" class="error-message">' +
								result.data.message +
								" " +
								result.data.detail_error_message +
								"</span>"
						);
					}
				},
				error: function (error) {
					console.log("Error:", error);
					$button.prop("disabled", false).html(originalText);
				},
			});
		}
	};

	// Send email asynchronously
	function sendEmailTrackingAsyncDokan(order_id, email_data) {
		$.ajax({
			type: "POST",
			url: ajax_url,
			dataType: "json",
			cache: false,
			data: {
				action: "send_email_async",
				order_id: order_id,
				email_data: email_data,
			},
			success: function (response) {
				console.log("Email sent:", response);
			},
			error: function (error) {
				console.log("Email sending failed:", error);
			},
		});
	}
});
