<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'wp_ajax_ajax_generate_label', 'auroship_ajax_generate_label' );
add_action( 'wp_enqueue_scripts', 'auroship_generate_label_js' );
add_action( 'admin_head', 'auroship_generate_label_js' );
add_action( 'admin_enqueue_scripts', 'auroship_style' );

/**
 * Enqueue css style
 *
 * @return void
 */
function auroship_style() {
	wp_enqueue_style( 'auroship_styles', AUROSHIP_PLUGIN_URL . '/assets/css/auroship-style.css', array(), AUROSHIP_PLUGIN_VERSION );
	wp_enqueue_script( 'jquery-tipTip', AUROSHIP_PLUGIN_URL . '/assets/js/jquery-tiptip/jquery.tipTip.min.js' );
}

/**
 * Get the data after generating the label
 *
 * @return string
 */
function auroship_ajax_generate_label() {
	if ( isset( $_POST['label_action'] ) && 'generate_label' == $_POST['label_action'] ) {
		$order_id = isset( $_POST['order_id'] ) ? intval( $_POST['order_id'] ) : 0;

		$wc = new WC_Auroship();

		$params = $wc->get_label_generate_params( $order_id );
		$params['packages'][0]['weight']['value'] = isset( $_POST['product_data']['product_weight'] ) ? floatval( filter_var( $_POST['product_data']['product_weight'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION ) ) : 0.0;
		$params['packages'][0]['dimensions']['length'] = isset( $_POST['product_data']['product_length'] ) ? floatval( filter_var( $_POST['product_data']['product_length'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION ) ) : 0.0;
		$params['packages'][0]['dimensions']['width'] = isset( $_POST['product_data']['product_width'] ) ? floatval( filter_var( $_POST['product_data']['product_width'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION ) ) : 0.0;
		$params['packages'][0]['dimensions']['height'] = isset( $_POST['product_data']['product_height'] ) ? floatval( filter_var( $_POST['product_data']['product_height'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION ) ) : 0.0;

		$res = Auroship_API::get_shipping_label( $params, $order_id );
		if ( !empty( $res['success'] ) ) {
			$order = wc_get_order( $order_id );
			$order->update_status( 'confirmed' );
			update_post_meta( $order_id, '_auroship_product_weight', $params['packages'][0]['weight']['value'] );
			update_post_meta( $order_id, '_package_length', $params['packages'][0]['dimensions']['length'] );
			update_post_meta( $order_id, '_package_width', $params['packages'][0]['dimensions']['width'] );
			update_post_meta( $order_id, '_package_height', $params['packages'][0]['dimensions']['height'] );

			$tracking_id = get_post_meta( $order_id, '_tracking_id', true );
			$base64_string = get_post_meta( $order_id, '_bas64_string', true );
			$delivery_start_date = get_post_meta( $order_id, '_delivery_start_date', true );
			$delivery_end_date = get_post_meta( $order_id, '_delivery_end_date', true );
			$pdf_url = Auroship_utilities::auroship_decode_and_save_pdf( $base64_string, $order_id );

			$date1 = new DateTime( $delivery_start_date );
			$date2 = new DateTime( $delivery_end_date );
			$formatted_delivery_date = $date1->format( 'd-m-Y' ) . ' to ' . $date2->format( 'd-m-Y' );
			$buyer_fname = explode( ' ', $params['shipTo']['name'] )[0];
			$seller_fname = explode( ' ', $params['shipFrom']['name'] )[0];
			$email_data = [
				'order_number' => $order_id,
				'tracking_number' => $tracking_id,
				'delivery_date' => $formatted_delivery_date,
				'buyer_name' => $buyer_fname,
				'buyer_email' => $params['shipTo']['email'],
				'seller_name' => $seller_fname,
				'seller_email' => $params['shipFrom']['email'],
				'order_status' => 'confirmed',
			];

			$response = array( 'tracking_id' => $tracking_id, 'pdf_url' => $pdf_url, 'email_data' => $email_data );
			wp_send_json_success( $response );
			die();
		} else {
			wp_send_json_error( $res );
			die();
		}
	}
}

/**
 * JavaScript functionality to generate label
 *
 * @return void
 */
function auroship_generate_label_js() {
	wp_enqueue_script( 'jquery' );

	if ( function_exists( 'dokan_is_seller_dashboard' ) && dokan_is_seller_dashboard() ) {
		wp_enqueue_style( 'auroship_styles', AUROSHIP_PLUGIN_URL . '/assets/css/auroship-style.css', array(), AUROSHIP_PLUGIN_VERSION );
		wp_register_script( 'generate-label-script', AUROSHIP_PLUGIN_URL . '/assets/js/generate-label-script-dokan.js', array( 'jquery' ), null, true );
	} else {
		if ( is_admin() ) {
			wp_register_script( 'generate-label-script', AUROSHIP_PLUGIN_URL . '/assets/js/generate-label-script.js', array( 'jquery' ), null, true );
		}
	}

	$orderid = 0;
	$max_gross_weight = !empty( get_option( 'auroship_max_gross_weight' ) ) ? get_option( 'auroship_max_gross_weight' ) : 0;
	$max_length = !empty( get_option( 'auroship_max_length' ) ) ? get_option( 'auroship_max_length' ) : 0;
	$max_width = !empty( get_option( 'auroship_max_width' ) ) ? get_option( 'auroship_max_width' ) : 0;
	$max_height = !empty( get_option( 'auroship_max_height' ) ) ? get_option( 'auroship_max_height' ) : 0;

	if ( isset( $_GET['post'] ) && is_admin() ) {
		$orderid = intval( $_GET['post'] );
	}

	if ( isset( $_GET['id'] ) && is_admin() ) {
		$orderid = intval( $_GET['id'] );
	}

	if ( isset( $_GET['order_id'] ) ) {
		$orderid = intval( $_GET['order_id'] );
	}

	$product_weights = get_post_meta( $orderid, '_product_weight', true );
	$product_weight = !empty( $product_weights ) ? $product_weights : 0;

	$params = array();
	if ( $orderid ) {
		$wc = new WC_Auroship();
		$params = $wc->get_label_generate_params( $orderid );
	}

	$php_data = array(
		'max_gross_weight' => $max_gross_weight,
		'max_length' => $max_length,
		'max_width' => $max_width,
		'max_height' => $max_height,
		'product_weight' => $product_weight,
		'order_id' => $orderid,
		'ajax_url' => admin_url( 'admin-ajax.php' ),
		'generate_label_params' => $params,
	);

	wp_localize_script( 'generate-label-script', 'phpVars', $php_data );
	wp_enqueue_script( 'generate-label-script' );
}
