<div>
    <div class="options_group padding-bottom-10">
        <p class="form-field">
            <label for="tracking_awb_number">AWB Number</label>
            <input type="text" readonly name="tracking_awb_number" id="tracking_awb_number" value="<?php echo esc_attr( $tracking_id ); ?>" placeholder="Awb Number">
        <p id="errMsgTrackNumber" class="error-message"></p>
        </p>
        <p class="form-field">
            <label for="shipping_provider">Shipping Provider</label>
            <input type="text" readonly name="shipping_provider" id="shipping_provider" value="<?php echo esc_attr( $shipping_provider ); ?>" placeholder="Shipping Provider">
            <input type="hidden" name="carrier_id" id="carrier_id" value="<?php echo esc_attr( $carrier_id ); ?>" placeholder="Carrier Id">
        <p id="errMsgShippingProvider" class="error-message"></p>
        </p>
    </div>
    <div class="no-border">
        <ul class="order_actions submitbox">
            <li class="wide">
                <button type="button" onclick="tracking_shipment()" class="button save_order button-primary" name="tracking_btn" id="tracking_btn">Track Shipment</button>
            </li>
        </ul>
    </div>
    <?php if ( $shipping_status ) {?>
        <div class="tracking-details">
            <ul>
                <li><label for="tracking_details"><strong>Tracking details:</strong></label></li>

                <li class="form-field flex-center-align">
                    <label for="tracking_awb_number"><strong>Current Status:</strong></label>
                    <span id="shipping_status"><?php echo esc_html( $shipping_status ); ?></span>
                </li>
                <?php if ( !in_array( $shipping_status, $specific_statuses ) ) {?>
                <li class="form-field flex-center-align">
                    <label for="estimated_delivery_date"><strong>Estimated Delivery:</strong></label>
                    <span id="estimated_delivery_date"><?php echo esc_html( $estimated_delivery_date ); ?></span>
                </li>
                <?php }?>
            </ul>
            <ul>
                <li>
                    <label for="tracking_history"><strong>Tracking History:</strong></label>
                </li>
                <div id="tracking-container">
                    <?php
foreach ( $tracking_event_code as $event_code ) {
	if ( !empty( $tracking_history_arr->payload ) ) {
		foreach ( $tracking_history_arr->payload->eventHistory as $event_history ) {
			if ( $event_history->eventCode === $event_code ) {
				$formateddate = new DateTime( $event_history->eventTime );
				$event_date = $formateddate->format( 'd-m-Y' );
				echo '<li class="flex-center-align"><label for="tracking_code"><strong>' . esc_html( $event_code ) . ': </strong></label>';
				echo '<span>' . esc_html( $event_date ) . '</span></li>';
				break;
			}
		}
	}
}
	?>
                </div>
            </ul>
        </div>
    <?php }?>
</div>
