<?php
/**
 * The Manomano marketplace Feed Template class.
 *
 * @link       https://rextheme.com
 * @since      1.1.4
 *
 * @package    Rex_Product_Feed
 * @subpackage Rex_Product_Feed/admin/feed-templates/
 */

/**
 * Defines the attributes and template for Manomano marketplace feed.
 *
 * @package    Rex_Product_Feed
 * @subpackage Rex_Product_Feed/admin/feed-templates/Rex_Feed_Template_Manomano
 * @author     RexTheme <info@rextheme.com>
 */
class Rex_Feed_Template_Manomano extends Rex_Feed_Abstract_Template {

	/**
	 * Define merchant's required and optional/additional attributes
	 *
	 * @return void
	 */
	protected function init_atts() {
		$this->attributes = array(
			'Required Information'    => array(
				'sku'                          => 'Sku',
				'sku_manufacturer'             => 'Sku Manufacturer',
				'manufacturer'                 => 'Manufacturer',
				'ean'                          => 'Ean',
				'title'                        => 'Title',
				'description'                  => 'Description',
				'product_price_vat_inc'        => 'Product Price Vat Inc',
				'shipping_price_vat_inc'       => 'Shipping Price Vat Inc',
				'quantity'                     => 'Quantity',
				'brand'                        => 'Brand',
				'merchant_category'            => 'Merchant Category',
				'product_url'                  => 'Product Url',
				'image_1'                      => 'Image 1',
				'carrier'                      => 'Carrier',
				'shipping_time'                => 'Shipping Time',
				'use_grid'                     => 'Use_grid',
				'shipping_time_carrier_grid_1' => 'Shipping Time Carrier Grid 1',
				'DisplayWeight'                => 'DisplayWeight',
				'DisplayLength'                => 'DisplayLength',
				'DisplayWidth'                 => 'DisplayWidth',
				'DisplayHeight'                => 'DisplayHeight',
				'is_mmf'                       => 'Is Mmf',
				'weight_net'                   => 'Weight Net',
				'icpe'                         => 'Icpe',
				'onu'                          => 'Onu',
				'security_file_number'         => 'Security File Number',
				'has_batch_number'             => 'Has Batch Number',
				'has_serial_number'            => 'Has Serial Number',
				'has_dluo'                     => 'Has Dluo',
				'is_fragile'                   => 'Is Fragile',
				'is_overpackaged'              => 'Is Overpackaged',
				'overpackage_instruction'      => 'Overpackage Instruction',
			),

			'Recommended Information' => array(
				'image_2'                  => 'image_2',
				'image_3'                  => 'image_3',
				'image_4'                  => 'image_4',
				'image_5'                  => 'image_5',
				'retail_price_vat_inc'     => 'retail_price_vat_inc',
				'product_vat_rate'         => 'product_vat_rate',
				'shipping_vat_rate'        => 'shipping_vat_rate',
				'manufacturer_pdf'         => 'manufacturer_pdf',
				'ParentSKU'                => 'ParentSKU',
				'parent_title'             => 'parent_title',
				'Cross_Sell_SKU'           => 'Cross_Sell_SKU',
				'ManufacturerWarrantyTime' => 'ManufacturerWarrantyTime',
			),

			'Optional Information'    => array(
				'free_return'                       => 'Free Return',
				'min_quantity'                      => 'Min Quantity',
				'increment'                         => 'Increment',
				'sales'                             => 'Sales',
				'eco_participation'                 => 'Eco Participation',
				'Price_per_m2_vat_inc'              => 'Price Per M2 Vat Inc',
				'shipping_price_supplement_vat_inc' => 'Shipping Price Supplement Vat Inc',
				'Color'                             => 'Color',
				'Unit_count'                        => 'Unit Count',
				'Unit_count_type'                   => 'Unit Count Type',
			),

		);
	}

	/**
	 * Define merchant's default attributes
	 *
	 * @return void
	 */
	protected function init_default_template_mappings() {
		$this->template_mappings = array(
			array(
				'attr'     => 'sku',
				'type'     => 'meta',
				'meta_key' => 'sku',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'title',
				'type'     => 'meta',
				'meta_key' => 'title',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'cdata',
				'limit'    => 0,
			),
			array(
				'attr'     => 'description',
				'type'     => 'meta',
				'meta_key' => 'description',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'quantity',
				'type'     => 'meta',
				'meta_key' => 'stock',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),

			array(
				'attr'     => 'sku_manufacturer',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'manufacturer',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'ean',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),

			array(
				'attr'     => 'product_price_vat_inc',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'shipping_price_vat_inc',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'brand',
				'type'     => 'meta',
				'meta_key' => 'brand',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'merchant_category',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'product_url',
				'type'     => 'meta',
				'meta_key' => 'link',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'image_1',
				'type'     => 'meta',
				'meta_key' => 'featured_image',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'carrier',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'shipping_time',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'use_grid',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'shipping_time_carrier_grid_1',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'DisplayWeight',
				'type'     => 'meta',
				'meta_key' => 'weight',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'DisplayLength',
				'type'     => 'meta',
				'meta_key' => 'length',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'DisplayWidth',
				'type'     => 'meta',
				'meta_key' => 'width',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'DisplayHeight',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'is_mmf',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'weight_net',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'icpe',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'onu',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'security_file_number',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'has_batch_number',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'has_serial_number',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'has_dluo',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'is_fragile',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'is_overpackaged',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),
			array(
				'attr'     => 'overpackage_instruction',
				'type'     => 'static',
				'meta_key' => '',
				'st_value' => '',
				'prefix'   => '',
				'suffix'   => '',
				'escape'   => 'default',
				'limit'    => 0,
			),

		);
	}
}
