<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace RexFeed\Google\Service\ShoppingContent;

class PosInventoryResponse extends \RexFeed\Google\Model
{
    /**
     * @var string
     */
    public $contentLanguage;
    /**
     * @var string
     */
    public $gtin;
    /**
     * @var string
     */
    public $itemId;
    /**
     * @var string
     */
    public $kind;
    protected $priceType = Price::class;
    protected $priceDataType = '';
    /**
     * @var string
     */
    public $quantity;
    /**
     * @var string
     */
    public $storeCode;
    /**
     * @var string
     */
    public $targetCountry;
    /**
     * @var string
     */
    public $timestamp;
    /**
     * @param string
     */
    public function setContentLanguage($contentLanguage)
    {
        $this->contentLanguage = $contentLanguage;
    }
    /**
     * @return string
     */
    public function getContentLanguage()
    {
        return $this->contentLanguage;
    }
    /**
     * @param string
     */
    public function setGtin($gtin)
    {
        $this->gtin = $gtin;
    }
    /**
     * @return string
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * @param string
     */
    public function setItemId($itemId)
    {
        $this->itemId = $itemId;
    }
    /**
     * @return string
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * @param string
     */
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    /**
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * @param Price
     */
    public function setPrice(Price $price)
    {
        $this->price = $price;
    }
    /**
     * @return Price
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * @param string
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    }
    /**
     * @return string
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * @param string
     */
    public function setStoreCode($storeCode)
    {
        $this->storeCode = $storeCode;
    }
    /**
     * @return string
     */
    public function getStoreCode()
    {
        return $this->storeCode;
    }
    /**
     * @param string
     */
    public function setTargetCountry($targetCountry)
    {
        $this->targetCountry = $targetCountry;
    }
    /**
     * @return string
     */
    public function getTargetCountry()
    {
        return $this->targetCountry;
    }
    /**
     * @param string
     */
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;
    }
    /**
     * @return string
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(PosInventoryResponse::class, 'RexFeed\\Google_Service_ShoppingContent_PosInventoryResponse');
