<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace RexFeed\Google\Service\ShoppingContent;

class Segments extends \RexFeed\Google\Model
{
    /**
     * @var string
     */
    public $brand;
    /**
     * @var string
     */
    public $categoryL1;
    /**
     * @var string
     */
    public $categoryL2;
    /**
     * @var string
     */
    public $categoryL3;
    /**
     * @var string
     */
    public $categoryL4;
    /**
     * @var string
     */
    public $categoryL5;
    /**
     * @var string
     */
    public $currencyCode;
    /**
     * @var string
     */
    public $customLabel0;
    /**
     * @var string
     */
    public $customLabel1;
    /**
     * @var string
     */
    public $customLabel2;
    /**
     * @var string
     */
    public $customLabel3;
    /**
     * @var string
     */
    public $customLabel4;
    protected $dateType = Date::class;
    protected $dateDataType = '';
    /**
     * @var string
     */
    public $offerId;
    /**
     * @var string
     */
    public $productTypeL1;
    /**
     * @var string
     */
    public $productTypeL2;
    /**
     * @var string
     */
    public $productTypeL3;
    /**
     * @var string
     */
    public $productTypeL4;
    /**
     * @var string
     */
    public $productTypeL5;
    /**
     * @var string
     */
    public $program;
    /**
     * @var string
     */
    public $title;
    protected $weekType = Date::class;
    protected $weekDataType = '';
    /**
     * @param string
     */
    public function setBrand($brand)
    {
        $this->brand = $brand;
    }
    /**
     * @return string
     */
    public function getBrand()
    {
        return $this->brand;
    }
    /**
     * @param string
     */
    public function setCategoryL1($categoryL1)
    {
        $this->categoryL1 = $categoryL1;
    }
    /**
     * @return string
     */
    public function getCategoryL1()
    {
        return $this->categoryL1;
    }
    /**
     * @param string
     */
    public function setCategoryL2($categoryL2)
    {
        $this->categoryL2 = $categoryL2;
    }
    /**
     * @return string
     */
    public function getCategoryL2()
    {
        return $this->categoryL2;
    }
    /**
     * @param string
     */
    public function setCategoryL3($categoryL3)
    {
        $this->categoryL3 = $categoryL3;
    }
    /**
     * @return string
     */
    public function getCategoryL3()
    {
        return $this->categoryL3;
    }
    /**
     * @param string
     */
    public function setCategoryL4($categoryL4)
    {
        $this->categoryL4 = $categoryL4;
    }
    /**
     * @return string
     */
    public function getCategoryL4()
    {
        return $this->categoryL4;
    }
    /**
     * @param string
     */
    public function setCategoryL5($categoryL5)
    {
        $this->categoryL5 = $categoryL5;
    }
    /**
     * @return string
     */
    public function getCategoryL5()
    {
        return $this->categoryL5;
    }
    /**
     * @param string
     */
    public function setCurrencyCode($currencyCode)
    {
        $this->currencyCode = $currencyCode;
    }
    /**
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * @param string
     */
    public function setCustomLabel0($customLabel0)
    {
        $this->customLabel0 = $customLabel0;
    }
    /**
     * @return string
     */
    public function getCustomLabel0()
    {
        return $this->customLabel0;
    }
    /**
     * @param string
     */
    public function setCustomLabel1($customLabel1)
    {
        $this->customLabel1 = $customLabel1;
    }
    /**
     * @return string
     */
    public function getCustomLabel1()
    {
        return $this->customLabel1;
    }
    /**
     * @param string
     */
    public function setCustomLabel2($customLabel2)
    {
        $this->customLabel2 = $customLabel2;
    }
    /**
     * @return string
     */
    public function getCustomLabel2()
    {
        return $this->customLabel2;
    }
    /**
     * @param string
     */
    public function setCustomLabel3($customLabel3)
    {
        $this->customLabel3 = $customLabel3;
    }
    /**
     * @return string
     */
    public function getCustomLabel3()
    {
        return $this->customLabel3;
    }
    /**
     * @param string
     */
    public function setCustomLabel4($customLabel4)
    {
        $this->customLabel4 = $customLabel4;
    }
    /**
     * @return string
     */
    public function getCustomLabel4()
    {
        return $this->customLabel4;
    }
    /**
     * @param Date
     */
    public function setDate(Date $date)
    {
        $this->date = $date;
    }
    /**
     * @return Date
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * @param string
     */
    public function setOfferId($offerId)
    {
        $this->offerId = $offerId;
    }
    /**
     * @return string
     */
    public function getOfferId()
    {
        return $this->offerId;
    }
    /**
     * @param string
     */
    public function setProductTypeL1($productTypeL1)
    {
        $this->productTypeL1 = $productTypeL1;
    }
    /**
     * @return string
     */
    public function getProductTypeL1()
    {
        return $this->productTypeL1;
    }
    /**
     * @param string
     */
    public function setProductTypeL2($productTypeL2)
    {
        $this->productTypeL2 = $productTypeL2;
    }
    /**
     * @return string
     */
    public function getProductTypeL2()
    {
        return $this->productTypeL2;
    }
    /**
     * @param string
     */
    public function setProductTypeL3($productTypeL3)
    {
        $this->productTypeL3 = $productTypeL3;
    }
    /**
     * @return string
     */
    public function getProductTypeL3()
    {
        return $this->productTypeL3;
    }
    /**
     * @param string
     */
    public function setProductTypeL4($productTypeL4)
    {
        $this->productTypeL4 = $productTypeL4;
    }
    /**
     * @return string
     */
    public function getProductTypeL4()
    {
        return $this->productTypeL4;
    }
    /**
     * @param string
     */
    public function setProductTypeL5($productTypeL5)
    {
        $this->productTypeL5 = $productTypeL5;
    }
    /**
     * @return string
     */
    public function getProductTypeL5()
    {
        return $this->productTypeL5;
    }
    /**
     * @param string
     */
    public function setProgram($program)
    {
        $this->program = $program;
    }
    /**
     * @return string
     */
    public function getProgram()
    {
        return $this->program;
    }
    /**
     * @param string
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }
    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * @param Date
     */
    public function setWeek(Date $week)
    {
        $this->week = $week;
    }
    /**
     * @return Date
     */
    public function getWeek()
    {
        return $this->week;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(Segments::class, 'RexFeed\\Google_Service_ShoppingContent_Segments');
