<?php
/**
 * The order tracking carriers.
 *
 * @package WooCommerce\PayPalCommerce\OrderTracking
 */

declare(strict_types=1);

namespace WooCommerce\PayPalCommerce\OrderTracking;

	return (array) apply_filters(
		'woocommerce_paypal_payments_tracking_carriers',
		array(
			'global' => array(
				'name'  => 'Global',
				'items' => array(
					'99MINUTOS'                  => _x( '99minutos', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'A2B_BA'                     => _x( 'A2B Express Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ABCUSTOM_SFTP'              => _x( 'AB Custom Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ACILOGISTIX'                => _x( 'ACI Logistix', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ACOMMERCE'                  => _x( 'ACOMMERCE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ACTIVOS24_API'              => _x( 'Activos24', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ADS'                        => _x( 'ADS Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AEROFLASH'                  => _x( 'AEROFLASH', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AGEDISS_SFTP'               => _x( 'Agediss', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AIR_21'                     => _x( 'AIR 21', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AIRSPEED'                   => _x( 'AIRSPEED', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AIRTERRA'                   => _x( 'Airterra', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AITWORLDWIDE_API'           => _x( 'AIT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AITWORLDWIDE_SFTP'          => _x( 'AIT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ALLIED_EXPRESS_FTP'         => _x( 'Allied Express (FTP)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ALLJOY'                     => _x( 'ALLJOY SUPPLY CHAIN', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AMAZON_EMAIL_PUSH'          => _x( 'Amazon', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AMAZON_ORDER'               => _x( 'Amazon order', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AMAZON_UK_API'              => _x( 'amazon_uk_api', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AMS_GRP'                    => _x( 'AMS Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ANDREANI_API'               => _x( 'Andreani', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ANTERAJA'                   => _x( 'Anteraja', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARAMEX'                     => _x( 'Aramex', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARAMEX_API'                 => _x( 'Aramex', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARASKARGO'                  => _x( 'Aras Cargo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARGENTS_WEBHOOK'            => _x( 'Argents Express Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ASENDIA_DE'                 => _x( 'asendia_de', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ATSHEALTHCARE_REFERENCE'    => _x( 'ATS Healthcare', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ATSHEALTHCARE'              => _x( 'ATS Healthcare', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AUEXPRESS'                  => _x( 'Au Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AUSTRALIA_POST_API'         => _x( 'Australia Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AVERITT'                    => _x( 'Averitt Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AXLEHIRE_FTP'               => _x( 'Axlehire', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AXLEHIRE'                   => _x( 'AxleHire', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BARQEXP'                    => _x( 'Barq', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BDMNET'                     => _x( 'BDMnet', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BEL_BELGIUM_POST'           => _x( 'bel_belgium_post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BLR_BELPOST'                => _x( 'Belpost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BERT'                       => _x( 'BERT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BESTTRANSPORT_SFTP'         => _x( 'Best Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BETTERTRUCKS'               => _x( 'Better Trucks', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BIGSMART'                   => _x( 'Big Smart', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BIOCAIR_FTP'                => _x( 'BioCair', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BJSHOMEDELIVERY'            => _x( 'BJS Distribution courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BJSHOMEDELIVERY_FTP'        => _x( 'BJS Distribution, Storage & Couriers - FTP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BLUEDART'                   => _x( 'BLUEDART', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BLUEDART_API'               => _x( 'Bluedart', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BOLLORE_LOGISTICS'          => _x( 'Bollore Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BOMI'                       => _x( 'Bomi Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BE_BPOST'                   => _x( 'Bpost (www.bpost.be)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BPOST_API'                  => _x( 'Bpost API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BPOST_INT'                  => _x( 'Bpost international', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BRT_IT_API'                 => _x( 'BRT Bartolini API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BUFFALO'                    => _x( 'BUFFALO', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BURD'                       => _x( 'Burd Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CHROBINSON'                 => _x( 'C.H. Robinson Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CAGO'                       => _x( 'Cago', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CANPAR'                     => _x( 'CANPAR', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CAPITAL'                    => _x( 'Capital Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CARRY_FLAP'                 => _x( 'Carry-Flap Co.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CBL_LOGISTICA_API'          => _x( 'CBL Logistica (API)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CDLDELIVERS'                => _x( 'CDL Last Mile', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CELERITAS'                  => _x( 'Celeritas Transporte', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CEVA'                       => _x( 'CEVA LOGISTICS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CEVA_TRACKING'              => _x( 'CEVA Package', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CHAZKI'                     => _x( 'Chazki', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CHIENVENTURE_WEBHOOK'       => _x( 'Chienventure', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CHILEXPRESS'                => _x( 'Chile Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CITY56_WEBHOOK'             => _x( 'City Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJ_GLS'                     => _x( 'CJ GLS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJ_LOGISTICS'               => _x( 'CJ Logistics International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJ_PHILIPPINES'             => _x( 'cj_philippines', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CLICKLINK_SFTP'             => _x( 'ClickLink', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_LOGISTICS'               => _x( 'CN Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COLLECTPLUS'                => _x( 'COLLECTPLUS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COM1EXPRESS'                => _x( 'ComOne Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CONCISE'                    => _x( 'Concise', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CONCISE_WEBHOOK'            => _x( 'Concise', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CONCISE_API'                => _x( 'Concise', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COORDINADORA_API'           => _x( 'Coordinadora', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COPA_COURIER'               => _x( 'Copa Airlines Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CORREOS_DE_ESPANA'          => _x( 'CORREOS DE ESPANA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CORREOSEXPRESS_API'         => _x( 'Correos Express (API)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CORREOS_ES'                 => _x( 'correos Express (www.correos.es)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COURANT_PLUS_API'           => _x( 'Courant Plus', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COURIER_POST'               => _x( 'COURIER POST', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COURIERPLUS'                => _x( 'COURIERPLUS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CRLEXPRESS'                 => _x( 'CRL Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CROSSFLIGHT'                => _x( 'Crossflight Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CRYOPDP_FTP'                => _x( 'CryoPDP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CESKAPOSTA_API'             => _x( 'Czech Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DEXPRESS_WEBHOOK'           => _x( 'D Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DACHSER'                    => _x( 'DACHSER', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DACHSER_WEB'                => _x( 'DACHSER', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DAESHIN'                    => _x( 'Daeshin', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DAIICHI'                    => _x( 'Daiichi Freight System Inc', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DANNIAO'                    => _x( 'Danniao', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DAO365'                     => _x( 'DAO365', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DAYROSS'                    => _x( 'Day & Ross', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DYLT'                       => _x( 'Daylight Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DBSCHENKER_API'             => _x( 'DB Schenker', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DBSCHENKER_B2B'             => _x( 'DB Schenker B2B', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DBSCHENKER_ICELAND'         => _x( 'DB Schenker Iceland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DDEXPRESS'                  => _x( 'DD Express Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DE_DHL'                     => _x( 'DE DHL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELCART_IN'                 => _x( 'delcart_in', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELIVERYOURPARCEL_ZA'       => _x( 'Deliver Your Parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELIVER_IT'                 => _x( 'Deliver-iT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELIVERE'                   => _x( 'delivere', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELIVERR_SFTP'              => _x( 'Deliverr', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELTEC_DE'                  => _x( 'DELTEC DE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DEMANDSHIP'                 => _x( 'DemandShip', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DEUTSCHE_DE'                => _x( 'deutsche_de', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_API'                    => _x( 'DHL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_REFERENCE_API'          => _x( 'DHL (Reference number)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_ACTIVE_TRACING'         => _x( 'DHL Active Tracing', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_ECOMMERCE_GC'           => _x( 'DHL eCommerce Greater China', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_GLOBAL_MAIL_API'        => _x( 'DHL eCommerce Solutions', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DE_DHL_EXPRESS'             => _x( 'DHL Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_SFTP'                   => _x( 'DHL Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_FR'                     => _x( 'DHL France (www.dhl.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_FREIGHT'                => _x( 'DHL Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL'                        => _x( 'dhl Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_GLOBAL_FORWARDING_API'  => _x( 'DHL Global Forwarding API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_GT_API'                 => _x( 'DHL Global Forwarding Guatemala', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_PA_API'                 => _x( 'DHL GLOBAL FORWARDING PANAMÁ', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IT_DHL_ECOMMERCE'           => _x( 'DHL International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_JP'                     => _x( 'DHL Japan', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_PARCEL_NL'              => _x( 'DHL Parcel NL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_SG'                     => _x( 'dhl Singapore', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_ES_SFTP'                => _x( 'DHL Spain Domestic', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_SUPPLYCHAIN_IN'         => _x( 'DHL supply chain India', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_SUPPLYCHAIN_ID'         => _x( 'DHL Supply Chain Indonesia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_AT'                     => _x( 'dhl_at', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_GLOBAL_MAIL'            => _x( 'dhl_global_mail', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_IT'                     => _x( 'dhl_it', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_PIECEID'                => _x( 'dhl_pieceid', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_SUPPLY_CHAIN_AU'        => _x( 'dhl_supply_chain_au', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHLPARCEL_UK'               => _x( 'dhlparcel_uk', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIALOGO_LOGISTICA_API'      => _x( 'Dialogo Logistica', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIALOGO_LOGISTICA'          => _x( 'Dialogo Logistica', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIRECTFREIGHT_AU_REF'       => _x( 'Direct Freight Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIREX'                      => _x( 'Direx', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DKSH'                       => _x( 'DKSH', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DMFGROUP'                   => _x( 'DMF', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DNJ_EXPRESS'                => _x( 'DNJ Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DOTZOT'                     => _x( 'DOTZOT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD'                        => _x( 'DPD', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_AT_SFTP'                => _x( 'DPD Austria', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_DELISTRACK'             => _x( 'DPD delistrack', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_NL'                     => _x( 'DPD Netherlands', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_RU_API'                 => _x( 'DPD Russia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_SK_SFTP'                => _x( 'DPD Slovakia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_CH_SFTP'                => _x( 'DPD Switzerland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_UK_SFTP'                => _x( 'DPD UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_DE'                     => _x( 'dpd_de', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_FR_REFERENCE'           => _x( 'dpd_fr_reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_UK'                     => _x( 'dpd_uk', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_DPEX'                    => _x( 'DPEX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPEX'                       => _x( 'DPEX (www.dpex.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DSV'                        => _x( 'DSV courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DSV_REFERENCE'              => _x( 'DSV Futurewave', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DX'                         => _x( 'DX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DX_B2B_CONNUM'              => _x( 'DX (B2B)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DX_FREIGHT'                 => _x( 'DX Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DYNALOGIC'                  => _x( 'Dynamic Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EASTWESTCOURIER_FTP'        => _x( 'East West Courier Pte Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EC_CN'                      => _x( 'EC_CN', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ECARGO'                     => _x( 'ECARGO', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ECEXPRESS'                  => _x( 'ECexpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ECMS'                       => _x( 'ECMS International Logistics Co.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ECOFREIGHT'                 => _x( 'Eco Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ECOURIER'                   => _x( 'ecourier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ECOUTIER'                   => _x( 'eCoutier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EFS'                        => _x( 'EFS (E-commerce Fulfillment Service)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ELITE_CO'                   => _x( 'Elite Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ELOGISTICA'                 => _x( 'elogistica', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ELTA_GR'                    => _x( 'elta_gr', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARE_EMIRATES_POST'          => _x( 'Emirates Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EMS'                        => _x( 'EMS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EMS_CN'                     => _x( 'ems_cn', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ENSENDA'                    => _x( 'ENSENDA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EFWNOW_API'                 => _x( 'Estes Forwarding Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ETOMARS'                    => _x( 'Etomars', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ETOTAL'                     => _x( 'eTotal Solution Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EDF_FTP'                    => _x( 'Eurodifarm', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EURODIS'                    => _x( 'eurodis', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EUROPAKET_API'              => _x( 'Europacket+', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYHERMES_UK_API'            => _x( 'EVRi', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EWE'                        => _x( 'EWE Global Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EXELOT_FTP'                 => _x( 'Exelot Ltd.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EXPEDITORS'                 => _x( 'Expeditors', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EXPEDITORS_API_REF'         => _x( 'Expeditors API Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EZSHIP'                     => _x( 'EZship', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FAIRSENDEN_API'             => _x( 'fairsenden', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FXTRAN'                     => _x( 'Falcon Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FAN'                        => _x( 'FAN COURIER EXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FNF_ZA'                     => _x( 'Fast & Furious', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTDESPATCH'               => _x( 'Fast Despatch Logistics Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTBOX'                    => _x( 'Fastbox', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTSHIP'                   => _x( 'Fastship Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTTRACK'                  => _x( 'fasttrack', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTWAY_AU'                 => _x( 'fastway_au', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTWAY_UK'                 => _x( 'FASTWAY_UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTWAY_US'                 => _x( 'FASTWAY_US', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTWAY_ZA'                 => _x( 'fastway_za', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FAXECARGO'                  => _x( 'Faxe Cargo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FEDEX_FR'                   => _x( 'FedEx® Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FEDEX_API'                  => _x( 'FedEx®', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FERCAM_IT'                  => _x( 'fercam_it', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FETCHR'                     => _x( 'Fetchr', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FIRST_LOGISTICS_API'        => _x( 'First Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FIRST_LOGISITCS'            => _x( 'first_logisitcs', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FITZMARK_API'               => _x( 'FitzMark', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FLASHEXPRESS_WEBHOOK'       => _x( 'Flash Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FLIGHTLG'                   => _x( 'Flight Logistics Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FLIPXP'                     => _x( 'FlipXpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FLYTEXPRESS'                => _x( 'FLYTEXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FORWARDAIR'                 => _x( 'Forward Air', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FOUR_PX_EXPRESS'            => _x( 'FOUR PX EXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FR_COLISSIMO'               => _x( 'fr_colissimo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FR_MONDIAL'                 => _x( 'fr_mondial', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FRAGILEPAK_SFTP'            => _x( 'FragilePAK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FRONTDOORCORP'              => _x( 'FRONTdoor Collective', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FUJEXP'                     => _x( 'FUJIE EXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GWLOGIS_API'                => _x( 'G.I.G', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GAC'                        => _x( 'GAC', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GATI_KWE_API'               => _x( 'Gati-KWE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GDPHARM'                    => _x( 'GDPharm Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GW_WORLD'                   => _x( 'Gebrüder Weiss', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GEODIS'                     => _x( 'GEODIS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GEODIS_API'                 => _x( 'GEODIS - Distribution & Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GPOST'                      => _x( 'Georgian Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GIAO_HANG'                  => _x( 'Giao hàng nhanh', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GIO_ECOURIER_API'           => _x( 'GIO Express Ecourier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GIO_ECOURIER'               => _x( 'GIO Express Inc', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GOGLOBALPOST'               => _x( 'Global Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOBEGISTICS'               => _x( 'GLOBEGISTICS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOVO'                      => _x( 'Glovo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS'                        => _x( 'GLS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_SPAIN_API'              => _x( 'GLS Spain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_DE'                     => _x( 'GLS_DE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_ES'                     => _x( 'GLS_ES', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_FR'                     => _x( 'GLS_FR', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_ITALY_FTP'              => _x( 'gls_italy_ftp', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_SPAIN'                  => _x( 'gls_spain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GOLS'                       => _x( 'GO Logistics & Storage', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GOPEOPLE'                   => _x( 'Go People', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GORUSH'                     => _x( 'Go Rush', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GOJEK'                      => _x( 'Gojek', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GREYHOUND'                  => _x( 'GREYHOUND', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAZET'                      => _x( 'Groupe Mazet', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HANJIN'                     => _x( 'HanJin', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HELLENIC_POST'              => _x( 'Hellenic (Greece) Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HELLMANN'                   => _x( 'Hellmann Worldwide Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HELTHJEM_API'               => _x( 'Helthjem', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HERMES_DE_FTP'              => _x( 'Hermes Germany', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HERMES_UK_SFTP'             => _x( 'Hermes UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HERMESWORLD_UK'             => _x( 'hermesworld_uk', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HEROEXPRESS'                => _x( 'Hero Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HFD'                        => _x( 'HFD', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HK_RPX'                     => _x( 'hk_rpx', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HOMELOGISTICS'              => _x( 'Home Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HOMERUNNER'                 => _x( 'HomeRunner', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HERMES_IT'                  => _x( 'HR Parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HSDEXPRESS'                 => _x( 'HSDEXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HSM_GLOBAL'                 => _x( 'HSM Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HUANTONG'                   => _x( 'HuanTong', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HUBBED'                     => _x( 'HUBBED', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HUNTER_EXPRESS_SFTP'        => _x( 'Hunter Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IBVENTURE_WEBHOOK'          => _x( 'IB Venture', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTUR_IS'                  => _x( 'Iceland Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ICSCOURIER'                 => _x( 'ICS COURIER', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IDEXPRESS_ID'               => _x( 'iDexpress Indonesia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IDN_POS'                    => _x( 'idn_pos', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IDS_LOGISTICS'              => _x( 'ids_logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ILYANGLOGIS'                => _x( 'Ilyang logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IMEXGLOBALSOLUTIONS'        => _x( 'imexglobalsolutions', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IMILE_API'                  => _x( 'iMile', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IML'                        => _x( 'IML courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IMX'                        => _x( 'IMX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INDIA_POST'                 => _x( 'India Post Domestic', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INDIA_POST_INT'             => _x( 'India Post International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INEXPOST'                   => _x( 'Inexpost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INNTRALOG_SFTP'             => _x( 'Inntralog GmbH', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INPOST_UK'                  => _x( 'InPost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INSTABOX_WEBHOOK'           => _x( 'Instabox', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTERNATIONAL_SEUR_API'     => _x( 'International Seur API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTERSMARTTRANS'            => _x( 'INTERSMARTTRANS & SOLUTIONS SL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTEX_DE'                   => _x( 'INTEX Paketdienst GmbH', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTIME_FTP'                 => _x( 'InTime', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ITHINKLOGISTICS'            => _x( 'iThink Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JTCARGO'                    => _x( 'J&T CARGO', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JTEXPRESS_PH'               => _x( 'J&T Express Philippines', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JTEXPRESS_SG_API'           => _x( 'J&T Express Singapore', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JT_LOGISTICS'               => _x( 'J&T International logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JAVIT'                      => _x( 'Javit', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_JCEX'                    => _x( 'JCEX courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JD_EXPRESS'                 => _x( 'JD Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JD_WORLDWIDE'               => _x( 'JD Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JETSHIP_MY'                 => _x( 'jetship_my', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JNE_API'                    => _x( 'JNE (API)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IDN_JNE'                    => _x( 'JNE Express (Jalur Nugraha Ekakurir)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JOYINGBOX'                  => _x( 'joyingbox', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KARGOMKOLAY'                => _x( 'KargomKolay (CargoMini)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KEDAEX'                     => _x( 'KedaEX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HK_TGX'                     => _x( 'Kerry Express Hong Kong', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KERRY_EXPRESS_TW_API'       => _x( 'Kerry Express TaiWan', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THA_KERRY'                  => _x( 'Kerry Express Thailand', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KERRY_EXPRESS_TH_WEBHOOK'   => _x( 'Kerry Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KNG'                        => _x( 'Keuhne + Nagel Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BE_KIALA'                   => _x( 'Kiala', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGISYSTEMS_SFTP'           => _x( 'Kiitääjät', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KOMON_EXPRESS'              => _x( 'Komon Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KRONOS_WEBHOOK'             => _x( 'Kronos Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KRONOS'                     => _x( 'Kronos Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KUEHNE'                     => _x( 'Kuehne + Nagel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LALAMOVE_API'               => _x( 'Lalamove', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LBCEXPRESS_FTP'             => _x( 'LBC EXPRESS INC.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LBCEXPRESS_API'             => _x( 'LBC EXPRESS INC.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LCTBR_API'                  => _x( 'LCT do Brasil', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LTU_LIETUVOS'               => _x( 'Lietuvos pastas', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LINKBRIDGE'                 => _x( 'Link Bridge(BeiJing)international logistics co.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LION_PARCEL'                => _x( 'LION PARCEL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LIVRAPIDE'                  => _x( 'Livrapide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGGI'                      => _x( 'Loggi', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGISTICSWORLDWIDE_KR'      => _x( 'LOGISTICSWORLDWIDE KR', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGISTICSWORLDWIDE_MY'      => _x( 'LOGISTICSWORLDWIDE MY', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGWIN_LOGISTICS'           => _x( 'Logwin Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGYSTO'                    => _x( 'Logysto', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LUWJISTIK'                  => _x( 'Luwjistik', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MX_CARGO'                   => _x( 'M&X cargo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'M3LOGISTICS'                => _x( 'M3 Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'REIMAGINEDELIVERY'          => _x( 'maergo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAGYAR_POSTA_API'           => _x( 'Magyar Posta', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAIL_BOX_ETC'               => _x( 'Mail Boxes Etc.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYS_EMS'                    => _x( 'Malaysia Post EMS / Pos Laju', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MALCA_AMIT_API'             => _x( 'Malca Amit', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MALCA_AMIT'                 => _x( 'Malca-Amit', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MARKEN'                     => _x( 'Marken', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MEDAFRICA'                  => _x( 'Med Africa Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MEEST'                      => _x( 'Meest', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MEGASAVE'                   => _x( 'megasave', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MENSAJEROSURBANOS_API'      => _x( 'Mensajeros Urbanos', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MWD'                        => _x( 'Metropolitan Warehouse & Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MWD_API'                    => _x( 'Metropolitan Warehouse & Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MHI'                        => _x( 'Mhi', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MIKROPAKKET'                => _x( 'Mikropakket', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MISUMI_CN'                  => _x( 'MISUMI Group Inc.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MNX'                        => _x( 'MNX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MOBI_BR'                    => _x( 'Mobi Logistica', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MONDIALRELAY_FR'            => _x( 'Mondial Relay France', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MONDIALRELAY_ES'            => _x( 'Mondial Relay Spain(Punto Pack)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MONDIAL_BE'                 => _x( 'MONDIAL_BE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MOOVA'                      => _x( 'Moova', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MORNINGLOBAL'               => _x( 'Morning Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MOTHERSHIP_API'             => _x( 'Mothership', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MOVIANTO'                   => _x( 'Movianto', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MUDITA'                     => _x( 'MUDITA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYDYNALOGIC'                => _x( 'My DynaLogic', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYSENDLE_API'               => _x( 'mySendle', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NMTRANSFER'                 => _x( 'N&M Transfer Co., Inc.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NACEX_SPAIN_REFERENCE'      => _x( 'nacex_spain_reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NAEKO_FTP'                  => _x( 'Naeko Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NAQEL_EXPRESS'              => _x( 'Naqel Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NEWZEALAND_COURIERS'        => _x( 'NEW ZEALAND COURIERS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NEWGISTICS'                 => _x( 'Newgistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NEWGISTICSAPI'              => _x( 'Newgistics API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NIGHTLINE_UK'               => _x( 'nightline_uk', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NIMBUSPOST'                 => _x( 'NimbusPost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NIPPON_EXPRESS_FTP'         => _x( 'Nippon Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NIPPON_EXPRESS'             => _x( 'Nippon Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NORTHLINE'                  => _x( 'Northline', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NOVA_POSHTA_API'            => _x( 'Nova Poshta API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NOVOFARMA_WEBHOOK'          => _x( 'Novofarma', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NTL'                        => _x( 'NTL logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NYTLOGISTICS'               => _x( 'NYT SUPPLY CHAIN LOGISTICS Co., LTD', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OHI_WEBHOOK'                => _x( 'Ohi', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHOPOLIVE'                  => _x( 'Olive', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OMLOGISTICS_API'            => _x( 'OM LOGISTICS LTD', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OMNIRPS_WEBHOOK'            => _x( 'Omni Returns', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ONTRAC'                     => _x( 'ONTRAC', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ORANGECONNEX'               => _x( 'orangeconnex', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ORANGE_DS'                  => _x( 'OrangeDS (Orange Distribution Solutions Inc)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OSM_WORLDWIDE_SFTP'         => _x( 'OSM Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OZEPARTS_SHIPPING'          => _x( 'Ozeparts Shipping', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'P2P_TRC'                    => _x( 'P2P TrakPak', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PACKETA'                    => _x( 'Packeta', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PACKFLEET'                  => _x( 'PACKFLEET', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PACKS'                      => _x( 'Packs', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAKAJO'                     => _x( 'Pakajo World', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PANDAGO_API'                => _x( 'Pandago', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PANDION'                    => _x( 'Pandion', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PANDU'                      => _x( 'PANDU', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PANTHER_REFERENCE_API'      => _x( 'Panther Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PANTHER_ORDER_NUMBER'       => _x( 'panther_order_number', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAPA_WEBHOOK'               => _x( 'Papa', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELRIGHT'                => _x( 'Parcel Right', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCEL_2_POST'              => _x( 'Parcel To Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELFORCE'                => _x( 'PARCELFORCE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELSTARS_WEBHOOK'        => _x( 'Parcelstars', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCLL'                     => _x( 'PARCLL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PASSPORTSHIPPING'           => _x( 'Passport Shipping', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PATHEON'                    => _x( 'Patheon Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAYO'                       => _x( 'Payo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PCHOME_API'                 => _x( 'Pchome Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PGEON_API'                  => _x( 'Pgeon', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PHSE_API'                   => _x( 'PHSE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PICKUPP_VNM'                => _x( 'pickupp_vnm', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PIDGE'                      => _x( 'Pidge', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PIL_LOGISTICS'              => _x( 'PIL Logistics (China) Co.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PLYCONGROUP'                => _x( 'Plycon Transportation Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POLARSPEED'                 => _x( 'PolarSpeed Inc', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTONE'                    => _x( 'Post ONE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTAPLUS'                  => _x( 'Posta Plus', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTE_ITALIANE_PACCOCELERE' => _x( 'Poste Italiane Paccocelere', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTEN_NORGE'               => _x( 'Posten Norge (www.posten.no)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTI_API'                  => _x( 'Posti API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTNL_INT_3_S'             => _x( 'PostNL International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NLD_POSTNL'                 => _x( 'PostNL International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTNL_INTERNATIONAL'       => _x( 'PostNL International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SWE_POSTNORD'               => _x( 'Postnord sweden', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTPLUS'                   => _x( 'PostPlus', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PROCARRIER'                 => _x( 'Pro Carrier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRODUCTCAREGROUP_SFTP'      => _x( 'Product Care Services Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PROFESSIONAL_COURIERS'      => _x( 'PROFESSIONAL COURIERS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PPL'                        => _x( 'Professional Parcel Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PROMEDDELIVERY'             => _x( 'ProMed Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PUROLATOR'                  => _x( 'purolator', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PUROLATOR_INTERNATIONAL'    => _x( 'Purolator International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'QTRACK'                     => _x( 'QTrack', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'QUALITYPOST'                => _x( 'qualitypost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'QINTL_API'                  => _x( 'Quickstat Courier LLC', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'QUIQUP'                     => _x( 'Quiqup', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RANSA_WEBHOOK'              => _x( 'Ransa', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'REDJEPAKKETJE'              => _x( 'Red je Pakketje', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RELAISCOLIS'                => _x( 'Relais Colis', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RHENUS_GROUP'               => _x( 'Rhenus Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RHENUS_UK_API'              => _x( 'Rhenus Logistics UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AIR_CANADA'                 => _x( 'Rivo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RIXONHK_API'                => _x( 'Rixon Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROCHE_INTERNAL_SFTP'        => _x( 'Roche Internal Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROYAL_MAIL_FTP'             => _x( 'Royal Mail', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROYALSHIPMENTS'             => _x( 'royalshipments', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RRDONNELLEY'                => _x( 'rrdonnelley', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RUSSIAN_POST'               => _x( 'Russian post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SAEE'                       => _x( 'saee', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SAGAWA'                     => _x( 'SAGAWA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SAGAWA_API'                 => _x( 'Sagawa', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SBERLOGISTICS_RU'           => _x( 'Sber Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SECRETLAB_WEBHOOK'          => _x( 'Secretlab', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SEINO_API'                  => _x( 'Seino', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SEKO_SFTP'                  => _x( 'SEKO Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SENDING'                    => _x( 'Sending Transporte Urgente y Comunicacion', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHOWL'                      => _x( 'SENHONG INTERNATIONAL LOGISTICS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NOWLOG_API'                 => _x( 'Sequoialog', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SERVIENTREGA'               => _x( 'Servientrega', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SERVIP_WEBHOOK'             => _x( 'SerVIP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SETEL'                      => _x( 'Setel Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SF_EX'                      => _x( 'SF Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SF_EXPRESS_CN'              => _x( 'SF Express China', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SGT_IT'                     => _x( 'SGT_IT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHADOWFAX'                  => _x( 'Shadowfax', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHENZHEN'                   => _x( 'shenzhen 1st International Logistics(Group)Co', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HOTSIN_CARGO'               => _x( 'SHENZHEN HOTSIN CARGO INTL FORWARDING CO., LTD', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KWT'                        => _x( 'Shenzhen Jinghuada Logistics Co.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHERPA'                     => _x( 'Sherpa', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPA'                      => _x( 'SHIPA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPPIE'                    => _x( 'Shippie', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPPIFY'                   => _x( 'Shippify, Inc', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPROCKET'                 => _x( 'Shiprocket X', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPX'                      => _x( 'ShipX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPXPRES'                  => _x( 'SHIPXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPX'                        => _x( 'Shopee Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPX_TH'                     => _x( 'Shopee Xpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHUNBANG_EXPRESS'           => _x( 'ShunBang Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHYPLITE'                   => _x( 'Shypmax', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SIMPLETIRE_WEBHOOK'         => _x( 'SimpleTire', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SIMSGLOBAL'                 => _x( 'Sims Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SIODEMKA'                   => _x( 'SIODEMKA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SKynet_WORLDWIDE'           => _x( 'SkyNet Worldwide Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SKY_POSTAL'                 => _x( 'SkyPostal', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SK_POSTA'                   => _x( 'Slovenska pošta', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SMARTCAT'                   => _x( 'SMARTCAT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SMARTKARGO'                 => _x( 'SmartKargo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SMG_EXPRESS'                => _x( 'SMG Direct', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SMSA_EXPRESS_WEBHOOK'       => _x( 'SMSA Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SNTGLOBAL_API'              => _x( 'Snt Global Etrax', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SOLISTICA_API'              => _x( 'solistica', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPANISH_SEUR_FTP'           => _x( 'Spanish Seur', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPECTRAN'                   => _x( 'Spectran', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPEEDEX'                    => _x( 'speedex', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPEEDY'                     => _x( 'Speedy', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPREETAIL_API'              => _x( 'Spreetail', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPRINT_PACK'                => _x( 'SPRINT PACK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SRT_TRANSPORT'              => _x( 'SRT Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STAR_TRACK_NEXT_FLIGHT'     => _x( 'Star Track Next Flight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STARLINKS_API'              => _x( 'Starlinks Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STARTRACK'                  => _x( 'startrack', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STAR_TRACK_WEBHOOK'         => _x( 'StarTrack', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STARTRACK_EXPRESS'          => _x( 'startrack_express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STATOVERNIGHT'              => _x( 'Stat Overnight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_STO'                     => _x( 'STO Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SWISHIP'                    => _x( 'Swiship', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SWISS_POST'                 => _x( 'SWISS POST', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'T_CAT'                      => _x( 'T-cat', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'T_CAT_API'                  => _x( 'T-cat', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGINEXT_WEBHOOK'           => _x( 'T&W Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TW_TAIWAN_POST'             => _x( 'Taiwan Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TAMERGROUP_WEBHOOK'         => _x( 'Tamer Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TAQBIN_HK'                  => _x( 'TAQBIN Hong Kong', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TAQBIN_SG'                  => _x( 'taqbin_sg', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TCS_API'                    => _x( 'TCS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TECOR'                      => _x( 'tecor', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TELEPORT_WEBHOOK'           => _x( 'Teleport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SIC_TELIWAY'                => _x( 'Teliway SIC Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TESTING_COURIER_WEBHOOK'    => _x( 'Testing Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TESTING_COURIER'            => _x( 'Testing Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TH_CJ'                      => _x( 'TH_CJ', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THIJS_NL'                   => _x( 'Thijs Logistiek', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THUNDEREXPRESS'             => _x( 'Thunder Express Australia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TIPSA_API'                  => _x( 'Tipsa API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TIPSA_REF'                  => _x( 'Tipsa Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_FR_REFERENCE'           => _x( 'TNT France Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_REFR'                   => _x( 'TNT Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_AU'                     => _x( 'tnt_au', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_CN'                     => _x( 'TNT_CN', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_DE'                     => _x( 'TNT_DE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_ES'                     => _x( 'TNT_ES', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_IT'                     => _x( 'tnt_it', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_JP'                     => _x( 'TNT_JP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_PL'                     => _x( 'TNT_PL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOLL_WEBHOOK'               => _x( 'Toll Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOLL_IPEC'                  => _x( 'TOLL IPEC', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOLL_PRIORITY'              => _x( 'Toll Priority', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOMYDOOR'                   => _x( 'Tomydoor', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TONAMI_FTP'                 => _x( 'Tonami', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESDEX'                      => _x( 'Top Ideal Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOTAL_EXPRESS_API'          => _x( 'Total Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOURLINE_REFERENCE'         => _x( 'Tourline Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THAIPARCELS'                => _x( 'TP Logistic', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRANS2U'                    => _x( 'Trans2u', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRANSMISSION'               => _x( 'TRANSMISSION', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TANET'                      => _x( 'Transport Ambientales', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRANSVIRTUAL'               => _x( 'TransVirtual', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRUNKRS'                    => _x( 'Trunkrs', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRUSK'                      => _x( 'Trusk France', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TUSKLOGISTICS'              => _x( 'Tusk Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TYP'                        => _x( 'TYP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'U_ENVIOS'                   => _x( 'U-ENVIOS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UBER_WEBHOOK'               => _x( 'Uber', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UCS'                        => _x( 'UCS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UDS'                        => _x( 'United Delivery Service', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UPS'                        => _x( 'United Parcel Service', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UP_EXPRESS'                 => _x( 'up_express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UPARCEL'                    => _x( 'uParcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UPS_API'                    => _x( 'UPS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UPS_FREIGHT'                => _x( 'UPS Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UPS_REFERENCE'              => _x( 'UPS Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'URGENT_CARGUS'              => _x( 'Urgent Cargus', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'US_APC'                     => _x( 'us_apc', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'USPS_API'                   => _x( 'USPS API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PB_USPSFLATS_FTP'           => _x( 'USPS Flats (Pitney Bowes)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'USPS_WEBHOOK'               => _x( 'USPS Informed Visibility - Webhook', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VALUE_WEBHOOK'              => _x( 'Value Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VIAXPRESS'                  => _x( 'ViaXpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VNPOST_API'                 => _x( 'Vietnam Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VIRTRANSPORT_SFTP'          => _x( 'Vir Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VNPOST_EMS'                 => _x( 'vnpost_ems', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VOX'                        => _x( 'VOX SOLUCION EMPRESARIAL SRL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WATKINS_SHEPARD'            => _x( 'watkins_shepard', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WEWORLDEXPRESS'             => _x( 'We World Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WESHIP_API'                 => _x( 'WeShip', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WESHIP'                     => _x( 'WeShip', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WHISTL_SFTP'                => _x( 'Whistl', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WINESHIPPING_WEBHOOK'       => _x( 'Wineshipping', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WISH_EMAIL_PUSH'            => _x( 'Wish', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WOOYOUNG_LOGISTICS_SFTP'    => _x( 'WOO YOUNG LOGISTICS CO., LTD.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WORLDCOURIER'               => _x( 'World Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WORLDNET'                   => _x( 'Worldnet Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WSPEXPRESS'                 => _x( 'WSP Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XYY'                        => _x( 'Xingyunyi Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XPEDIGO'                    => _x( 'Xpedigo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XPRESSBEES'                 => _x( 'XPRESSBEES', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YAMATO'                     => _x( 'YAMATO', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TAQBIN_SG_API'              => _x( 'Yamato Singapore', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YIFAN'                      => _x( 'YiFan Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YODEL'                      => _x( 'yodel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YODEL_API'                  => _x( 'Yodel API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YODEL_DIR'                  => _x( 'Yodel Direct', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YODEL_INTNL'                => _x( 'Yodel International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YUSEN'                      => _x( 'Yusen Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YUSEN_SFTP'                 => _x( 'Yusen Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YYCOM'                      => _x( 'yycom', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YYEXPRESS'                  => _x( 'YYEXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZTO_DOMESTIC'               => _x( 'ZTO Express China', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZUELLIGPHARMA_SFTP'         => _x( 'Zuellig Pharma Korea', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),

			),
			'AG'     => array(
				'name'  => _x( 'Argentina', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'FASTRACK' => _x( 'Fasttrack', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ANDREANI' => _x( 'Grupo logistico Andreani', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARG_OCA'  => _x( 'OCA Argentina', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'AU'     => array(
				'name'  => _x( 'Australia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ADSONE'                    => _x( 'Adsone', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ALLIEDEXPRESS'             => _x( 'Allied Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARAMEX_AU'                 => _x( 'Aramex Australia (formerly Fastway AU)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AU_AU_POST'                => _x( 'Australia Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BLUESTAR'                  => _x( 'Blue Star', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BONDSCOURIERS'             => _x( 'Bonds Courier Service (bondscouriers.com.au)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BORDEREXPRESS'             => _x( 'Border Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COPE'                      => _x( 'Cope Sensitive Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COURIERS_PLEASE'           => _x( 'CouriersPlease (couriersplease.com.au)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELIVERE'                  => _x( 'deliverE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DESIGNERTRANSPORT_WEBHOOK' => _x( 'Designer Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_AU'                    => _x( 'DHL Supply Chain Australia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIRECTCOURIERS'            => _x( 'Direct Couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DTDC_AU'                   => _x( 'DTDC Australia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ENDEAVOUR_DELIVERY'        => _x( 'Endeavour Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HUNTER_EXPRESS'            => _x( 'Hunter Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ICUMULUS'                  => _x( 'iCumulus', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTERPARCEL_AU'            => _x( 'Interparcel Australia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NEWAY'                     => _x( 'Neway Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELPOINT'               => _x( 'Parcelpoint', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PFLOGISTICS'               => _x( 'PFL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SENDLE'                    => _x( 'Sendle', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPPIT'                   => _x( 'Shippit', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THENILE_WEBHOOK'           => _x( 'SortHub courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STAR_TRACK_EXPRESS'        => _x( 'Star Track Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AUS_STARTRACK'             => _x( 'StarTrack (startrack.com.au)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TFM'                       => _x( 'TFM Xpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TIGFREIGHT'                => _x( 'TIG Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOLL'                      => _x( 'Toll IPEC', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UBI_LOGISTICS'             => _x( 'UBI Smart Parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XL_EXPRESS'                => _x( 'XL Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'AT'     => array(
				'name'  => _x( 'Austria', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'AUSTRIAN_POST_EXPRESS' => _x( 'Austrian Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AU_AUSTRIAN_POST'      => _x( 'Austrian Post (Registered)', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'BGD'    => array(
				'name'  => _x( 'Bangladesh', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'PAPERFLY' => _x( 'Paperfly Private Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'BE'     => array(
				'name'  => _x( 'Belgium', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'B_TWO_C_EUROPE'            => _x( 'B2C courier Europe', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_BENELUX'               => _x( 'dhl benelux', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BEL_DHL'                   => _x( 'DHL Benelux', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LANDMARK_GLOBAL'           => _x( 'Landmark Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LANDMARK_GLOBAL_REFERENCE' => _x( 'Landmark Global Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MIKROPAKKET_BE'            => _x( 'Mikropakket Belgium', 'Name of carrier', 'woocommerce-paypal-payments' ),

				),
			),
			'BIH'    => array(
				'name'  => _x( 'Bosnia and Herzegovina', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BH_POSTA' => _x( 'BH Posta (www.posta.ba)', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'BR'     => array(
				'name'  => _x( 'Brazil', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BRA_CORREIOS'  => _x( 'Correios Brazil', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIRECTLOG'     => _x( 'Directlog', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FRETERAPIDO'   => _x( 'Frete Rapido', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTELIPOST'    => _x( 'Intelipost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOTAL_EXPRESS' => _x( 'Total Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'BG'     => array(
				'name'  => _x( 'Bulgaria', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'A1POST'            => _x( 'A1Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BG_BULGARIAN_POST' => _x( 'Bulgarian Posts', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'KHM'    => array(
				'name'  => _x( 'Cambodia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'AFLLOG_FTP'         => _x( 'AFL LOGISTICS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KHM_CAMBODIA_POST'  => _x( 'Cambodia Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROADRUNNER_FREIGHT' => _x( 'Roadbull Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),

				),
			),
			'CA'     => array(
				'name'  => _x( 'Canada', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CA_CANADA_POST'            => _x( 'Canada Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CHITCHATS'                 => _x( 'Chit Chats', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CORPORATECOURIERS_WEBHOOK' => _x( 'Corporate Couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COURANT_PLUS'              => _x( 'Courant Plus', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOBAL_ESTES'              => _x( 'Estes Express Lines', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DICOM'                     => _x( 'GLS Logistic Systems Canada Ltd./Dicom', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOCUS_WEBHOOK'             => _x( 'Locus courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOOMIS_EXPRESS'            => _x( 'Loomis Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MBW'                       => _x( 'MBW Courier Inc.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NATIONEX'                  => _x( 'Nationex courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELPAL_WEBHOOK'         => _x( 'ParcelPal', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AIR_CANADA_GLOBAL'         => _x( 'Rivo (Air canada)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROUTIFIC_WEBHOOK'          => _x( 'Routific', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RPXLOGISTICS'              => _x( 'RPX Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STALLIONEXPRESS'           => _x( 'Stallion Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZIINGFINALMILE'            => _x( 'Ziing Final Mile Inc', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'CL'     => array(
				'name'  => _x( 'Chile', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BLUEX'   => _x( 'Blue Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STARKEN' => _x( 'STARKEN couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'CN'     => array(
				'name'  => _x( 'China', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CN_17POST'         => _x( '17 Post Service', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ACSWORLDWIDE'      => _x( 'ACS Worldwide Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CAINIAO'           => _x( 'AliExpress Standard Shipping', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ANJUN'             => _x( 'Anjun couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ANSERX'            => _x( 'ANSERX courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AUPOST_CN'         => _x( 'AuPost China', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BEL_RS'            => _x( 'BEL North Russia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_BESTEXPRESS'    => _x( 'Best Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_BOXC'           => _x( 'BoxC courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BUYLOGIC'          => _x( 'buylogic', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CPEX'              => _x( 'Captain Express International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CGS_EXPRESS'       => _x( 'CGS Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_CHINA_POST_EMS' => _x( 'China Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CHUKOU1'           => _x( 'Chukou1', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJPACKET'          => _x( 'CJ Packet', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CLEVY_LINKS'       => _x( 'Clevy Links', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CNDEXPRESS'        => _x( 'CND Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CNEXPS'            => _x( 'CNE Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COMET_TECH'        => _x( 'CometTech', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CPACKET'           => _x( 'Cpacket couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CUCKOOEXPRESS'     => _x( 'Cuckoo Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DEX_I'             => _x( 'DEX-I courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIDADI'            => _x( 'DIDADI Logistics tech', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPE_EXPRESS'       => _x( 'DPE Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DTD_EXPR'          => _x( 'DTD Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EMPS_CN'           => _x( 'EMPS Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_EQUICK'         => _x( 'Equick China', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESHIPPING'         => _x( 'Eshipping', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZES_EXPRESS'       => _x( 'Eshun international Logistic', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FAR_INTERNATIONAL' => _x( 'Far international', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FARGOOD'           => _x( 'FarGood', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FULFILLME'         => _x( 'Fulfillme', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GANGBAO'           => _x( 'GANGBAO Supplychain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GESWL'             => _x( 'GESWL Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_GOFLY'          => _x( 'GoFly', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HDB'               => _x( 'Haidaibao', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HDB_BOX'           => _x( 'Haidaibao (BOX)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HH_EXP'            => _x( 'Hua Han Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HUAHAN_EXPRESS'    => _x( 'HUAHANG EXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HUODULL'           => _x( 'Huodull', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HX_EXPRESS'        => _x( 'HX Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IDEXPRESS'         => _x( 'IDEX courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTEL_VALLEY'      => _x( 'Intel-Valley Supply chain (ShenZhen) Co. Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'J_NET'             => _x( 'J-Net', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JINDOUYUN'         => _x( 'jindouyun courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JOOM_LOGIS'        => _x( 'Joom Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JOYING_BOX'        => _x( 'Joying Box', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'K1_EXPRESS'        => _x( 'K1 Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KY_EXPRESS'        => _x( 'Kua Yue Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LALAMOVE'          => _x( 'Lalamove', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LEADER'            => _x( 'leader', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SDH_SCM'           => _x( 'lightning monkey', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGISTERS'         => _x( 'Logisters', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LTIANEXP'          => _x( 'LTIAN EXP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LTL'               => _x( 'LTL COURIER', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MORE_LINK'         => _x( 'Morelink', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MXE'               => _x( 'MXE Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NANJINGWOYUAN'     => _x( 'Nanjing Woyuan', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ONEWORLDEXPRESS'   => _x( 'One World Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PADTF'             => _x( 'padtf.com', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAGO'              => _x( 'Pago Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAN_ASIA'          => _x( 'Pan-Asia International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_PAYPAL_PACKAGE' => _x( 'PayPal Package', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PFCEXPRESS'        => _x( 'PFC Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_POST56'         => _x( 'Post56', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HKD'               => _x( 'Qingdao HKD International Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ETS_EXPRESS'       => _x( 'RETS express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RUSTON'            => _x( 'Ruston', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_SF_EXPRESS'     => _x( 'SF Express (www.sf-express.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SFB2C'             => _x( 'SF International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SFC_LOGISTICS'     => _x( 'SFC', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SFCSERVICE'        => _x( 'SFC Service', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DAJIN'             => _x( 'Shanghai Aqrum Chemical Logistics Co.Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SINOTRANS'         => _x( 'Sinotrans', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STONE3PL'          => _x( 'STONE3PL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SYPOST'            => _x( 'Sunyou Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TARRIVE'           => _x( 'TONDA GLOBAL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOPHATTEREXPRESS'  => _x( 'Tophatter Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOPYOU'            => _x( 'TopYou', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UC_EXPRE'          => _x( 'ucexpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VIWO'              => _x( 'VIWO IoT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WANBEXPRESS'       => _x( 'WanbExpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WEASHIP'           => _x( 'Weaship', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_WEDO'           => _x( 'WeDo Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WINIT'             => _x( 'WinIt', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WISE_EXPRESS'      => _x( 'Wise Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_WISHPOST'       => _x( 'WishPost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XQ_EXPRESS'        => _x( 'XQ Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YANWEN'            => _x( 'Yanwen Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YDH_EXPRESS'       => _x( 'YDH express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ELIAN_POST'        => _x( 'Yilian (Elian) Supply Chain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YINGNUO_LOGISTICS' => _x( 'yingnuo logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YTO'               => _x( 'YTO Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CN_YUNDA'          => _x( 'Yunda Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YUNEXPRESS'        => _x( 'YunExpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZJS_EXPRESS'       => _x( 'ZJS International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZTO_EXPRESS'       => _x( 'ZTO Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'COL'    => array(
				'name'  => _x( 'Colombia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'COORDINADORA' => _x( 'Coordinadora', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'HRV'    => array(
				'name'  => _x( 'Croatia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'GLS_CROTIA'   => _x( 'GLS Croatia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HRV_HRVATSKA' => _x( 'Hrvatska posta', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OVERSE_EXP'   => _x( 'Overseas Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'CY'     => array(
				'name'  => _x( 'Cyprus', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CYPRUS_POST_CYP' => _x( 'Cyprus Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'CZ'     => array(
				'name'  => _x( 'Czech Republic', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CESKA_CZ' => _x( 'Ceska Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_CZ'   => _x( 'GLS Czech Republic', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'DNK'    => array(
				'name'  => _x( 'Denmark', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BUDBEE_WEBHOOK'        => _x( 'Budbee courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DANSKE_FRAGT'          => _x( 'Danske Fragtaend', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTNORD_LOGISTICS_DK' => _x( 'ostnord denmark', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTNORD_LOGISTICS'    => _x( 'PostNord Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XPRESSEN_DK'           => _x( 'Xpressen courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'EST'    => array(
				'name'  => _x( 'Estonia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'OMNIVA' => _x( 'Omniva', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'FIN'    => array(
				'name'  => _x( 'Finland', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'MATKAHUOLTO' => _x( 'Matkahuolto', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTI'       => _x( 'Posti courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'FR'     => array(
				'name'  => _x( 'France', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CHRONOPOST_FR'  => _x( 'Chronopost france (www.chronopost.fr)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COLIS_PRIVE'    => _x( 'Colis Privé', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FR_COLIS'       => _x( 'Colissimo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CUBYN'          => _x( 'Cubyn', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_FR'         => _x( 'DPD France', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FR_EXAPAQ'      => _x( 'DPD France (formerly exapaq)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GEODIS_ESPACE'  => _x( 'Geodis E-space', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HEPPNER_FR'     => _x( 'Heppner France', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LA_POSTE_SUIVI' => _x( 'La Poste', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_FR'         => _x( 'TNT France', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VIRTRANSPORT'   => _x( 'VIR Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'DE'     => array(
				'name'  => _x( 'Germany', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'HERMES_DE'              => _x( 'Hermes Germany', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AO_DEUTSCHLAND'         => _x( 'AO Deutschland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DE_DPD_DELISTRACK'      => _x( 'DPD Germany', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FIEGE'                  => _x( 'Fiege Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GEIS'                   => _x( 'Geis CZ', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GEL_EXPRESS'            => _x( 'Gel Express Logistik', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GENERAL_OVERNIGHT'      => _x( 'Go!Express and logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HEPPNER'                => _x( 'Heppner Internationale Spedition GmbH & Co.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HERMES_2MANN_HANDLING'  => _x( 'Hermes Einrichtungs Service GmbH & Co. KG', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NOX_NACHTEXPRESS'       => _x( 'Innight Express Germany GmbH (nox NachtExpress)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LIEFERY'                => _x( 'liefery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NOX_NIGHT_TIME_EXPRESS' => _x( 'NOX NightTimeExpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELONE'              => _x( 'PARCEL ONE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRESSIODE'              => _x( 'Pressio', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RABEN_GROUP'            => _x( 'Raben Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STRECK_TRANSPORT'       => _x( 'Streck Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SWISHIP_DE'             => _x( 'Swiship DE', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'GR'     => array(
				'name'  => _x( 'Greece', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ACS_GR'           => _x( 'ACS Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EASY_MAIL'        => _x( 'Easy Mail', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GENIKI_GR'        => _x( 'Geniki Taxydromiki', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPEEDCOURIERS_GR' => _x( 'Speed Couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPEEDEXCOURIER'   => _x( 'SPEEDEX couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'HK'     => array(
				'name'  => _x( 'Hong Kong', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CFL_LOGISTICS'         => _x( 'CFL Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJ_HK_INTERNATIONAL'   => _x( 'CJ Logistics International(Hong Kong)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CLE_LOGISTICS'         => _x( 'CL E-Logistics Solutions Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CONTINENTAL'           => _x( 'Continental', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COSTMETICSNOW'         => _x( 'Cosmetics Now', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DEALERSEND'            => _x( 'DealerSend', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_ECOMERCE_ASA'      => _x( 'DHL eCommerce Asia (API)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_GLOBAL_MAIL_ASIA'  => _x( 'DHL Global Mail Asia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_HK'                => _x( 'DHL Hong Kong', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_HK'                => _x( 'DPD Hong Kong', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DTDC_EXPRESS'          => _x( 'DTDC express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOBAVEND'             => _x( 'Globavend', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HK_POST'               => _x( 'Hongkong Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JANCO'                 => _x( 'Janco Ecommerce', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JS_EXPRESS'            => _x( 'JS EXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KEC'                   => _x( 'KEC courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KERRY_ECOMMERCE'       => _x( 'Kerry eCommerce', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LHT_EXPRESS'           => _x( 'LHT Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGISTICSWORLDWIDE_HK' => _x( 'Logistic Worldwide Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAINWAY'               => _x( 'Mainway', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MORNING_EXPRESS'       => _x( 'Morning Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OKAYPARCEL'            => _x( 'OkayParcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OMNIPARCEL'            => _x( 'Omni Parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PALEXPRESS'            => _x( 'PAL Express Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PICKUP'                => _x( 'Pickupp', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'QUANTIUM'              => _x( 'Quantium', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RPX'                   => _x( 'RPX Online', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SEKOLOGISTICS'         => _x( 'SEKO Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIP_IT_ASIA'          => _x( 'Ship It Asia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SMOOTH'                => _x( 'Smooth Couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'STEPFORWARDFS'         => _x( 'STEP FORWARD FREIGHT SERVICE CO LTD', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SFPLUS_WEBHOOK'        => _x( 'Zeek courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZEEK_2_DOOR'           => _x( 'Zeek2Door', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'HU'     => array(
				'name'  => _x( 'Hungary', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'DPD_HGRY'  => _x( 'DPD Hungary', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAGYAR_HU' => _x( 'Magyar Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'IN'     => array(
				'name'  => _x( 'India', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BOMBINOEXP'           => _x( 'Bombino Express Pvt', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IND_DELHIVERY'        => _x( 'Delhivery India', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELIVERYONTIME'       => _x( 'DELIVERYONTIME LOGISTICS PVT LTD', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DTDC_IN'              => _x( 'DTDC India', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IND_ECOM'             => _x( 'Ecom Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EKART'                => _x( 'Ekart logistics (ekartlogistics.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IND_FIRSTFLIGHT'      => _x( 'First Flight Couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IND_GATI'             => _x( 'Gati-KWE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IND_GOJAVAS'          => _x( 'GoJavas', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HOLISOL'              => _x( 'Holisol', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LEXSHIP'              => _x( 'LexShip', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OCS'                  => _x( 'OCS ANA Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELLED_IN'         => _x( 'Parcelled.in', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PICKRR'               => _x( 'Pickrr', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IND_SAFEEXPRESS'      => _x( 'Safexpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SCUDEX_EXPRESS'       => _x( 'Scudex Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHREE_ANJANI_COURIER' => _x( 'Shree Anjani Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHREE_MARUTI'         => _x( 'Shree Maruti Courier Services Pvt Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHREENANDANCOURIER'   => _x( 'SHREE NANDAN COURIER', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHREETIRUPATI'        => _x( 'SHREE TIRUPATI COURIER SERVICES PVT. LTD.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPOTON'               => _x( 'SPOTON Logistics Pvt Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRACKON'              => _x( 'Trackon Couriers Pvt. Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'ID'     => array(
				'name'  => _x( 'Indonesia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ALFATREX'        => _x( 'AlfaTrex', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CHOIR_EXP'       => _x( 'Choir Express Indonesia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INDOPAKET'       => _x( 'INDOPAKET', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JX'              => _x( 'JX courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KURASI'          => _x( 'KURASI', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NINJAVAN_ID'     => _x( 'Ninja Van Indonesia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NINJAVAN_WB'     => _x( 'Ninjavan Webhook', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MGLOBAL'         => _x( 'PT MGLOBAL LOGISTICS INDONESIA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRIMAMULTICIPTA' => _x( 'PT Prima Multi Cipta', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RCL'             => _x( 'Red Carpet Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RPX_ID'          => _x( 'RPX Indonesia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SAP_EXPRESS'     => _x( 'SAP EXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SIN_GLBL'        => _x( 'Sin Global Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TIKI_ID'         => _x( 'Tiki shipment', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRANS_KARGO'     => _x( 'Trans Kargo Internasional', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WAHANA_ID'       => _x( 'Wahana express (www.wahana.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'IE'     => array(
				'name'  => _x( 'Ireland', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'AN_POST'    => _x( 'An Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_IR'     => _x( 'DPD Ireland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTWAY_IR' => _x( 'Fastway Ireland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WISELOADS'  => _x( 'Wiseloads', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'IL'     => array(
				'name'  => _x( 'Israel', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ISRAEL_POST'       => _x( 'Israel Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ISR_POST_DOMESTIC' => _x( 'Israel Post Domestic', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'IT'     => array(
				'name'  => _x( 'Italy', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BRT_IT_PARCELID'   => _x( 'BRT Bartolini (Parcel ID)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BRT_IT'            => _x( 'BRT Couriers Italy', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARCO_SPEDIZIONI'   => _x( 'Arco Spedizioni SP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BLINKLASTMILE'     => _x( 'Blink', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BRT_IT_SENDER_REF' => _x( 'BRT Bartolini (Sender Reference)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DMM_NETWORK'       => _x( 'DMM Network', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLS_IT'            => _x( 'GLS Italy', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HRPARCEL'          => _x( 'HR Parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'I_DIKA'            => _x( 'i-dika', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LICCARDI_EXPRESS'  => _x( 'LICCARDI EXPRESS COURIER', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MILKMAN'           => _x( 'Milkman Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IT_NEXIVE'         => _x( 'Nexive (TNT Post Italy)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IT_POSTE_ITALIA'   => _x( 'Poste Italiane', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SAILPOST'          => _x( 'SAILPOST', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SDA_IT'            => _x( 'SDA Italy', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_CLICK_IT'      => _x( 'TNT-Click Italy', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'JP'     => array(
				'name'  => _x( 'Japan', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'EFEX'           => _x( 'eFEx (E-Commerce Fulfillment & Express)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JPN_JAPAN_POST' => _x( 'Japan Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KWE_GLOBAL'     => _x( 'KWE Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAIL_PLUS'      => _x( 'MailPlus', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAILPLUS_JPN'   => _x( 'MailPlus (Japan)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SEINO'          => _x( 'Seino', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'JEY'    => array(
				'name'  => _x( 'Jersey', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'JERSEY_POST' => _x( 'Jersey Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'KR'     => array(
				'name'  => _x( 'Korea', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CELLO_SQUARE'     => _x( 'Cello Square', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CROSHOT'          => _x( 'Croshot', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DOORA'            => _x( 'Doora Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EPARCEL_KR'       => _x( 'eParcel Korea', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KPOST'            => _x( 'Korea Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KR_KOREA_POST'    => _x( 'Koreapost (www.koreapost.go.kr)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KYUNGDONG_PARCEL' => _x( 'Kyungdong Parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOTTE'            => _x( 'Lotte Global Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RINCOS'           => _x( 'Rincos', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROCKET_PARCEL'    => _x( 'Rocket Parcel International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIP_GATE'        => _x( 'ShipGate', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPTER'          => _x( 'SHIPTER', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SRE_KOREA'        => _x( 'SRE Korea (www.srekorea.co.kr)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOLOS'            => _x( 'Tolos courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'KWT'    => array(
				'name'  => _x( 'Kuwait', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'POSTA_PLUS' => _x( 'Posta Plus', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'LAO'    => array(
				'name'  => _x( "Lao People's Democratic Republic (the)", 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'LAO_POST' => _x( 'Lao Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'LVA'    => array(
				'name'  => _x( 'Latvia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CDEK'           => _x( 'CDEK courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LATVIJAS_PASTS' => _x( 'Latvijas Pasts', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'LT'     => array(
				'name'  => _x( 'Lithuania', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'VENIPAK' => _x( 'Venipak', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'MY'     => array(
				'name'  => _x( 'Malaysia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ABXEXPRESS_MY'     => _x( 'ABX Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYS_AIRPAK'        => _x( 'Airpak Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CITYLINK_MY'       => _x( 'City-Link Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJ_CENTURY'        => _x( 'CJ Century', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJ_INT_MY'         => _x( 'CJ International Malaysia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COLLECTCO'         => _x( 'CollectCo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FMX'               => _x( 'FMX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYS_GDEX'          => _x( 'GDEX Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JTEXPRESS'         => _x( 'J&T EXPRESS MALAYSIA', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JINSUNG'           => _x( 'JINSUNG TRADING', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JOCOM'             => _x( 'Jocom', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KANGAROO_MY'       => _x( 'Kangaroo Worldwide Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LINE'              => _x( 'Line Clear Express & Logistics Sdn Bhd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGISTIKA'         => _x( 'Logistika', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'M_XPRESS'          => _x( 'M Xpress Sdn Bhd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYS_MYS_POST'      => _x( 'Malaysia Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MATDESPATCH'       => _x( 'Matdespatch', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYS_MYPOST_ONLINE' => _x( 'Mypostonline', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NATIONWIDE_MY'     => _x( 'Nationwide Express Courier Services Bhd (www.nationwide.com.my)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NINJAVAN_MY'       => _x( 'Ninja Van (www.ninjavan.co)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PICKUPP_MYS'       => _x( 'PICK UPP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYS_SKYNET'        => _x( 'Skynet Malaysia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TAQBIN_MY'         => _x( 'TAQBIN Malaysia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WEPOST'            => _x( 'WePost Sdn Bhd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WYNGS'             => _x( 'Wyngs', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZEPTO_EXPRESS'     => _x( 'ZeptoExpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'MX'     => array(
				'name'  => _x( 'Mexico', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CORREOS_DE_MEXICO' => _x( 'Correos Mexico', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MEX_ESTAFETA'      => _x( 'Estafeta (www.estafeta.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GRUPO'             => _x( 'Grupo ampm', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HOUNDEXPRESS'      => _x( 'Hound Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IVOY_WEBHOOK'      => _x( 'Ivoy courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MEX_SENDA'         => _x( 'Mexico Senda Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAQUETEXPRESS'     => _x( 'Paquetexpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MEX_REDPACK'       => _x( 'Redpack', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'NL'     => array(
				'name'  => _x( 'Netherlands', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BROUWER_TRANSPORT' => _x( 'Brouwer Transport en Logistiek', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NLD_DHL'           => _x( 'DHL Netherlands', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FIEGE_NL'          => _x( 'Fiege Netherlands', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NLD_GLS'           => _x( 'GLS Netherlands', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HAPPY2POINT'       => _x( 'Happy 2ThePoint', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAPER_EXPRESS'     => _x( 'Paper Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTNL_INTL_3S'    => _x( 'PostNL International 3S', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRUNKRS_WEBHOOK'   => _x( 'Trunkrs courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'NZ'     => array(
				'name'  => _x( 'New Zealand', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'FASTWAY_NZ'     => _x( 'Fastway New Zealand', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTERPARCEL_NZ' => _x( 'Interparcel New Zealand', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAINFREIGHT'    => _x( 'Mainfreight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NZ_NZ_POST'     => _x( 'New Zealand Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOLL_NZ'        => _x( 'Toll New Zealand', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'NG'     => array(
				'name'  => _x( 'Nigeria', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'NIPOST_NG' => _x( 'NIpost (www.nipost.gov.ng)', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'NO'     => array(
				'name'  => _x( 'Norway', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'HELTHJEM' => _x( 'Helthjem', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'PAK'    => array(
				'name'  => _x( 'Pakistan', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'FORRUN' => _x( 'forrun Pvt Ltd (Arpatech Venture)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TCS'    => _x( 'TCS courier	', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'PRY'    => array(
				'name'  => _x( 'Paraguay', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'AEX' => _x( 'AEX Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'PH'     => array(
				'name'  => _x( 'Philippines', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'TWO_GO'         => _x( '2GO Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PHL_JAMEXPRESS' => _x( 'Jam Express Philippines', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PIXSELL'        => _x( 'PIXSELL LOGISTICS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RAF_PH'         => _x( 'RAF Philippines', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XDE_WEBHOOK'    => _x( 'Ximex Delivery Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XPOST'          => _x( 'Xpost.ph', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'PL'     => array(
				'name'  => _x( 'Poland', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'DHL_PL'            => _x( 'DHL Poland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_POLAND'        => _x( 'DPD Poland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FEDEX_POLAND'      => _x( 'FedEx® Poland Domestic', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INPOST_PACZKOMATY' => _x( 'InPost Paczkomaty', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PL_POCZTA_POLSKA'  => _x( 'Poczta Polska', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROYAL_MAIL'        => _x( 'Royal Mail', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'PT'     => array(
				'name'  => _x( 'Portugal', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ADICIONAL'      => _x( 'Adicional Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BNEED'          => _x( 'Bneed courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CARRIERS'       => _x( 'Carriers courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRT_CHRONOPOST' => _x( 'Chronopost Portugal', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRT_CTT'        => _x( 'CTT Portugal', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELNEXT'        => _x( 'Delnext', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'RO'     => array(
				'name'  => _x( 'Romania', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'DPD_RO'   => _x( 'DPD Romania', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTA_RO' => _x( 'Post Roman (www.posta-romana.ro)', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'RUS'    => array(
				'name'  => _x( 'Russia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'BOX_BERRY'     => _x( 'Boxberry courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CSE'           => _x( 'CSE courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_PARCEL_RU' => _x( 'DHL Parcel Russia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DOBROPOST'     => _x( 'DobroPost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_RU'        => _x( 'DPD Russia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EXPRESSSALE'   => _x( 'Expresssale', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GBS_BROKER'    => _x( 'GBS-Broker', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PONY_EXPRESS'  => _x( 'Pony express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHOPFANS'      => _x( 'ShopfansRU LLC', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'SAU'    => array(
				'name'  => _x( 'Saudi Arabia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'SAU_SAUDI_POST'   => _x( 'Saudi Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SMSA_EXPRESS'     => _x( 'SMSA Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THABIT_LOGISTICS' => _x( 'Thabit Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZAJIL_EXPRESS'    => _x( 'Zajil Express Company', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'SRB'    => array(
				'name'  => _x( 'Serbia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'POST_SERBIA' => _x( 'Posta Serbia', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'SG'     => array(
				'name'  => _x( 'Singapore', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CLOUDWISH_ASIA'   => _x( 'Cloudwish Asia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SG_DETRACK'       => _x( 'Detrack', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FONSEN'           => _x( 'Fonsen Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GRAB_WEBHOOK'     => _x( 'Grab courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SIMPLYPOST'       => _x( 'J&T Express Singapore', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JANIO'            => _x( 'Janio Asia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'IND_JAYONEXPRESS' => _x( 'Jayon Express (JEX)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'JET_SHIP'         => _x( 'Jet-Ship Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KGMHUB'           => _x( 'KGM Hub', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LEGION_EXPRESS'   => _x( 'Legion Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NHANS_SOLUTIONS'  => _x( 'Nhans Solutions', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NINJAVAN_SG'      => _x( 'Ninja van Singapore', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELPOST_SG'    => _x( 'Parcel Post Singapore', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARKNPARCEL'      => _x( 'Park N Parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PICKUPP_SGP'      => _x( 'PICK UPP (Singapore)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SG_QXPRESS'       => _x( 'Qxpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RAIDEREX'         => _x( 'RaidereX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ROADBULL'         => _x( 'Red Carpet Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RZYEXPRESS'       => _x( 'RZY Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SG_SG_POST'       => _x( 'Singapore Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SG_SPEEDPOST'     => _x( 'Singapore Speedpost', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TCK_EXPRESS'      => _x( 'TCK Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COUREX'           => _x( 'Urbanfox', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WMG'              => _x( 'WMG Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZYLLEM'           => _x( 'Zyllem', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'SVK'    => array(
				'name'  => _x( 'Slovakia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'GLS_SLOV' => _x( 'GLS General Logistics Systems Slovakia s.r.o.', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'SVN'    => array(
				'name'  => _x( 'Slovenia', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'GLS_SLOVEN'    => _x( 'GLS Slovenia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POST_SLOVENIA' => _x( 'Post of Slovenia', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'ZA'     => array(
				'name'  => _x( 'South Africa', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ZA_COURIERIT'              => _x( 'Courier IT', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DAWN_WING'                 => _x( 'Dawn Wing', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPE_SOUTH_AFRC'            => _x( 'DPE South Africa', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTEXPRESS'                => _x( 'Internet Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'COLLIVERY'                 => _x( 'MDS Collivery Pty (Ltd)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RAM'                       => _x( 'RAM courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SKYNET_ZA'                 => _x( 'Skynet World Wide Express South Africa', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SOUTH_AFRICAN_POST_OFFICE' => _x( 'South African Post Office', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZA_SPECIALISED_FREIGHT'    => _x( 'Specialised Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THECOURIERGUY'             => _x( 'The Courier Guy', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'ES'     => array(
				'name'  => _x( 'Spain', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ABCUSTOM'           => _x( 'AB Custom Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ADERONLINE'         => _x( 'Ader couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ASIGNA'             => _x( 'ASIGNA courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESP_ASM'            => _x( 'ASM(GLS Spain)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CBL_LOGISTICA'      => _x( 'CBL Logistica', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CORREOS_EXPRESS'    => _x( 'Correos Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_PARCEL_ES'      => _x( 'DHL parcel Spain(www.dhl.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_ES'             => _x( 'DHL Spain(www.dhl.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ECOSCOOTING'        => _x( 'ECOSCOOTING', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESP_ENVIALIA'       => _x( 'Envialia', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ENVIALIA_REFERENCE' => _x( 'Envialia Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTEGRA2_FTP'       => _x( 'Integra2', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MRW_FTP'            => _x( 'MRW courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESP_MRW'            => _x( 'MRW spain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NACEX'              => _x( 'NACEX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NACEX_ES'           => _x( 'NACEX Spain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESP_NACEX'          => _x( 'NACEX Spain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PAACK_WEBHOOK'      => _x( 'Paack courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESP_PACKLINK'       => _x( 'Packlink', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ESP_REDUR'          => _x( 'Redur Spain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRT_INT_SEUR'       => _x( 'SEUR International', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRT_SEUR'           => _x( 'SEUR portugal', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SEUR_ES'            => _x( 'Seur Spain', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SEUR_SP_API'        => _x( 'Spanish Seur API', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPRING_GDS'         => _x( 'Spring GDS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SZENDEX'            => _x( 'SZENDEX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_NL'             => _x( 'THT Netherland', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TIPSA'              => _x( 'TIPSA courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT'                => _x( 'TNT Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOBAL_TNT'         => _x( 'TNT global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TOURLINE'           => _x( 'tourline', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VAMOX'              => _x( 'VAMOX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VIA_EXPRESS'        => _x( 'Viaxpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZELERIS'            => _x( 'Zeleris', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'SE'     => array(
				'name'  => _x( 'Sweden', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'AIRMEE_WEBHOOK' => _x( 'Airmee couriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BRING'          => _x( 'Bring', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DBSCHENKER_SE'  => _x( 'DB Schenker (www.dbschenker.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DBSCHENKER_SV'  => _x( 'DB Schenker Sweden', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'CH'     => array(
				'name'  => _x( 'Switzerland', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ASENDIA_HK'     => _x( 'Asendia HonKong', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PLANZER'        => _x( 'Planzer Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SWISS_POST_FTP' => _x( 'Swiss Post FTP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VIAEUROPE'      => _x( 'ViaEurope', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'TW'     => array(
				'name'  => _x( 'Taiwan', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CNWANGTONG'      => _x( 'cnwangtong', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CTC_EXPRESS'     => _x( 'CTC Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIMERCO'         => _x( 'Dimerco Express Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HCT_LOGISTICS'   => _x( 'HCT LOGISTICS CO.LTD.', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KERRYTJ'         => _x( 'Kerry TJ Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PRESIDENT_TRANS' => _x( 'PRESIDENT TRANSNET CORP', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOBAL_EXPRESS'  => _x( 'Tai Wan Global Business', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'TH'     => array(
				'name'  => _x( 'Thailand', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ALPHAFAST'             => _x( 'Alphafast', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CJ_KR'                 => _x( 'CJ Korea Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THA_DYNAMIC_LOGISTICS' => _x( 'Dynamic Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FASTRK_SERV'           => _x( 'Fastrak Services', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FLASHEXPRESS'          => _x( 'Flash Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NIM_EXPRESS'           => _x( 'Nim Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NINJAVAN_THAI'         => _x( 'Ninja van Thai', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SENDIT'                => _x( 'Sendit', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SKYBOX'                => _x( 'SKYBOX', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THA_THAILAND_POST'     => _x( 'Thailand Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'TR'     => array(
				'name'  => _x( 'Turkey', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'ASE'           => _x( 'ASE KARGO', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CDEK_TR'       => _x( 'CDEK TR', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PTS'           => _x( 'PTS courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PTT_POST'      => _x( 'PTT Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPENTEGRA'   => _x( 'ShipEntegra', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YURTICI_KARGO' => _x( 'Yurtici Kargo', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'UA'     => array(
				'name'  => _x( 'Ukraine', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'NOVA_POSHTA_INT' => _x( 'Nova Poshta (International)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NOVA_POSHTA'     => _x( 'Nova Poshta (novaposhta.ua)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'POSTA_UKR'       => _x( 'UkrPoshta', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'AE'     => array(
				'name'  => _x( 'United Arab Emirates', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'IBEONE'         => _x( 'Beone Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MARA_XPRESS'    => _x( 'Mara Xpress', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FETCHR_WEBHOOK' => _x( 'Mena 360 (Fetchr)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ONECLICK'       => _x( 'One click delivery services', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SKYNET_UAE'     => _x( 'SKYNET UAE', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'GB'     => array(
				'name'  => _x( 'United Kingdom', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'AMAZON'                  => _x( 'Amazon Shipping', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AO_COURIER'              => _x( 'AO Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'APC_OVERNIGHT'           => _x( 'APC overnight (apc-overnight.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'APC_OVERNIGHT_CONNUM'    => _x( 'APC Overnight Consignment', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'APG'                     => _x( 'APG eCommerce Solutions', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ARK_LOGISTICS'           => _x( 'ARK Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GB_ARROW'                => _x( 'Arrow XL', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ASENDIA_UK'              => _x( 'Asendia UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BH_WORLDWIDE'            => _x( 'B&H Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BIRDSYSTEM'              => _x( 'BirdSystem', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'BLUECARE'                => _x( 'Bluecare Express Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CAE_DELIVERS'            => _x( 'CAE Delivers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'CARIBOU'                 => _x( 'Caribou', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DAIGLOBALTRACK'          => _x( 'DAI Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DELTEC_UK'               => _x( 'Deltec Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_REFR'                => _x( 'DHl (Reference number)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DHL_UK'                  => _x( 'dhl UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIAMOND_EUROGISTICS'     => _x( 'Diamond Eurogistics Limited', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DIRECTPARCELS'           => _x( 'Direct Parcels', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DMS_MATRIX'              => _x( 'DMSMatrix', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_LOCAL'               => _x( 'DPD Local', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DPD_LOCAL_REF'           => _x( 'DPD Local reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DX_SFTP'                 => _x( 'DX (SFTP)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'EU_FLEET_SOLUTIONS'      => _x( 'EU Fleet Solutions', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FEDEX_UK'                => _x( 'FedEx® UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'FURDECO'                 => _x( 'Furdeco', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GBA'                     => _x( 'GBA Services Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GEMWORLDWIDE'            => _x( 'GEM Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HERMES'                  => _x( 'HermesWorld UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HOME_DELIVERY_SOLUTIONS' => _x( 'Home Delivery Solutions Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'INTERPARCEL_UK'          => _x( 'Interparcel UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MYHERMES'                => _x( 'MyHermes UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NATIONAL_SAMEDAY'        => _x( 'National Sameday', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GB_NORSK'                => _x( 'Norsk Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OCS_WORLDWIDE'           => _x( 'OCS WORLDWIDE', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PALLETWAYS'              => _x( 'Palletways', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GB_PANTHER'              => _x( 'Panther', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PANTHER_REFERENCE'       => _x( 'Panther Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCEL2GO'               => _x( 'Parcel2Go', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PARCELINKLOGISTICS'      => _x( 'Parcelink Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PLUS_LOG_UK'             => _x( 'Plus UK Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RPD2MAN'                 => _x( 'RPD2man Deliveries', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SKYNET_UK'               => _x( 'Skynet UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'AMAZON_FBA_SWISHIP'      => _x( 'Swiship UK', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'THEDELIVERYGROUP'        => _x( 'TDG – The Delivery Group', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PALLET_NETWORK'          => _x( 'The Pallet Network', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_UK'                  => _x( 'TNT UK Limited (www.tnt.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TNT_UK_REFR'             => _x( 'TNT UK Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GB_TUFFNELLS'            => _x( 'Tuffnells Parcels Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TUFFNELLS_REFERENCE'     => _x( 'Tuffnells Parcels Express- Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UK_UK_MAIL'              => _x( 'UK mail (ukmail.com)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WHISTL'                  => _x( 'Whistl', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WNDIRECT'                => _x( 'wnDirect', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UK_XDP'                  => _x( 'XDP Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XDP_UK_REFERENCE'        => _x( 'XDP Express Reference', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XPERT_DELIVERY'          => _x( 'Xpert Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UK_YODEL'                => _x( 'Yodel (www.yodel.co.uk)', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'US'     => array(
				'name'  => _x( 'United States', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'GIO_EXPRESS'          => _x( 'Gio Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOBALTRANZ'          => _x( 'GlobalTranz', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GSI_EXPRESS'          => _x( 'GSI EXPRESS', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GSO'                  => _x( 'GSO (GLS-USA)', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'HIPSHIPPER'           => _x( 'Hipshipper', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'GLOBAL_IPARCEL'       => _x( 'i-parcel', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'DESCARTES'            => _x( 'Innovel courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'US_LASERSHIP'         => _x( 'LaserShip', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LONESTAR'             => _x( 'Lone Star Overnight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'MAILAMERICAS'         => _x( 'MailAmericas', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NEWEGGEXPRESS'        => _x( 'Newegg Express', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'US_OLD_DOMINION'      => _x( 'Old Dominion Freight Line', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'OSM_WORLDWIDE'        => _x( 'OSM Worldwide', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PCFCORP'              => _x( 'PCF Final Mile', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PILOT_FREIGHT'        => _x( 'Pilot Freight Services', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PITNEY_BOWES'         => _x( 'Pitney Bowes', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'PITTOHIO'             => _x( 'PITT OHIO', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'QWINTRY'              => _x( 'Qwintry Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'RL_US'                => _x( 'RL Carriers', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SAIA_FREIGHT'         => _x( 'Saia LTL Freight', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SHIPTOR'              => _x( 'Shiptor', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SONICTL'              => _x( 'Sonic Transportation & Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SEFL'                 => _x( 'Southeastern Freight Lines', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SPEEDEE'              => _x( 'Spee-Dee Delivery', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'SUTTON'               => _x( 'Sutton Transport', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TAZMANIAN_FREIGHT'    => _x( 'Tazmanian Freight Systems', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TFORCE_FINALMILE'     => _x( 'TForce Final Mile', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'LOGISTYX_TRANSGROUP'  => _x( 'Transgroup courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'TRUMPCARD'            => _x( 'TRUMPCARD LLC', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'USPS'                 => _x( 'United States Postal Service', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'UPS_MAIL_INNOVATIONS' => _x( 'UPS Mail Innovations', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'USF_REDDAWAY'         => _x( 'USF Reddaway', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'USHIP'                => _x( 'uShip courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WESTBANK_COURIER'     => _x( 'West Bank Courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WESTGATE_GL'          => _x( 'Westgate Global', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'WIZMO'                => _x( 'Wizmo', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'XPO_LOGISTICS'        => _x( 'XPO logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'YAKIT'                => _x( 'Yakit courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'US_YRC'               => _x( 'YRC courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'ZINC'                 => _x( 'Zinc courier', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'URY'    => array(
				'name'  => _x( 'Uruguay', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'CORREO_UY' => _x( 'Correo Uruguayo', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
			'VN'     => array(
				'name'  => _x( 'Vietnam', 'Name of carrier country', 'woocommerce-paypal-payments' ),
				'items' => array(
					'JTEXPRESS_VN'     => _x( 'J&T Express Vietnam', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'KERRYTTC_VN'      => _x( 'Kerry Express (Vietnam) Co Ltd', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'NTLOGISTICS_VN'   => _x( 'Nhat Tin Logistics', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VNM_VIETNAM_POST' => _x( 'Vietnam Post', 'Name of carrier', 'woocommerce-paypal-payments' ),
					'VNM_VIETTELPOST'  => _x( 'ViettelPost', 'Name of carrier', 'woocommerce-paypal-payments' ),
				),
			),
		)
	);
