<?php
/**
 * Title: Featured Products: Fresh & Tasty
 * Slug: woocommerce-blocks/featured-products-fresh-and-tasty
 * Categories: WooCommerce
 */
?>
<!-- wp:heading {"level":3,"align":"wide"} -->
<h3 class="wp-block-heading alignwide"><?php esc_html_e( 'Fresh &amp; tasty goods', 'woocommerce' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:columns {"verticalAlignment":null,"align":"wide"} -->
<div class="wp-block-columns alignwide">
	<!-- wp:column {"style":{"layout":{"type":"constrained"}} -->
	<div class="wp-block-column">
		<!-- wp:image {"align":"full","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
		<figure class="wp-block-image alignfull size-full">
			<img src="<?php echo esc_url( plugins_url( 'images/pattern-placeholders/sweet-organic-lemons.png', dirname( __FILE__ ) ) ); ?>" alt="<?php esc_attr_e( 'Placeholder image used to represent a product being showcased as Sweet organic Lemons.', 'woocommerce' ); ?>" />
		</figure>
		<!-- /wp:image -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"0"},"margin":{"top":"5px","bottom":"0"}}}} -->
		<div class="wp-block-columns" style="margin-top:5px;margin-bottom:0">
			<!-- wp:column {"width":"67%","style":{"typography":{"fontWeight":"600"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
			<div class="wp-block-column" style="font-weight:600;flex-basis:67%">
				<!-- wp:paragraph {"fontSize":"small"} -->
				<p class="has-small-font-size"><?php esc_html_e( 'Sweet Organic Lemons', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"33%","layout":{"type":"constrained","justifyContent":"right"}} -->
			<div class="wp-block-column" style="flex-basis:33%">
				<!-- wp:paragraph {"align":"left","fontSize":"small"} -->
				<p class="has-text-align-left has-small-font-size"><?php esc_html_e( 'from $1.99', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:column -->

	<!-- wp:column {"style":{"layout":{"type":"constrained"}} -->
	<div class="wp-block-column">
		<!-- wp:image {"align":"full","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
		<figure class="wp-block-image alignfull size-full">
			<img src="<?php echo esc_url( plugins_url( 'images/pattern-placeholders/fresh-organic-tomatoes.png', dirname( __FILE__ ) ) ); ?>" alt="<?php esc_attr_e( 'Placeholder image used to represent a product being showcased as Fresh Organic Tomatoes.', 'woocommerce' ); ?>" />
		</figure>
		<!-- /wp:image -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"0"},"margin":{"top":"5px","bottom":"0"}}}} -->
		<div class="wp-block-columns" style="margin-top:5px;margin-bottom:0">
			<!-- wp:column {"width":"67%","style":{"typography":{"fontWeight":"600"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
			<div class="wp-block-column" style="font-weight:600;flex-basis:67%">
				<!-- wp:paragraph {"fontSize":"small"} -->
				<p class="has-small-font-size"><?php esc_html_e( 'Fresh Organic Tomatoes', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"33%","layout":{"type":"constrained","justifyContent":"right"}} -->
			<div class="wp-block-column" style="flex-basis:33%">
				<!-- wp:paragraph {"align":"left","fontSize":"small"} -->
				<p class="has-text-align-left has-small-font-size"><?php esc_html_e( 'from $2.99', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:column -->

	<!-- wp:column {"style":{"layout":{"type":"constrained"}} -->
	<div class="wp-block-column">
		<!-- wp:image {"align":"full","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
		<figure class="wp-block-image alignfull size-full">
			<img src="<?php echo esc_url( plugins_url( 'images/pattern-placeholders/fresh-lettuce-washed.png', dirname( __FILE__ ) ) ); ?>" alt="<?php esc_attr_e( 'Placeholder image used to represent a product being showcased as Fresh Lettuce Washed.', 'woocommerce' ); ?>" />
		</figure>
		<!-- /wp:image -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"0"},"margin":{"top":"5px","bottom":"0"}}}} -->
		<div class="wp-block-columns" style="margin-top:5px;margin-bottom:0">
			<!-- wp:column {"width":"67%","style":{"typography":{"fontWeight":"600"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
			<div class="wp-block-column" style="font-weight:600;flex-basis:67%">
				<!-- wp:paragraph {"fontSize":"small"} -->
				<p class="has-small-font-size"><?php esc_html_e( 'Fresh Lettuce (Washed)', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"33%","layout":{"type":"constrained","justifyContent":"right"}} -->
			<div class="wp-block-column" style="flex-basis:33%">
				<!-- wp:paragraph {"align":"left","fontSize":"small"} -->
				<p class="has-text-align-left has-small-font-size"><?php esc_html_e( 'from $0.99', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:column -->

	<!-- wp:column {"style":{"layout":{"type":"constrained"}} -->
	<div class="wp-block-column">
		<!-- wp:image {"align":"full","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
		<figure class="wp-block-image alignfull size-full">
			<img src="<?php echo esc_url( plugins_url( 'images/pattern-placeholders/russet-organic-potatoes.png', dirname( __FILE__ ) ) ); ?>" alt="<?php esc_attr_e( 'Placeholder image used to represent a product being showcased as Russet Organic Potatoes.', 'woocommerce' ); ?>" />
		</figure>
		<!-- /wp:image -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"0"},"margin":{"top":"5px","bottom":"0"}}}} -->
		<div class="wp-block-columns" style="margin-top:5px;margin-bottom:0">
			<!-- wp:column {"width":"67%","style":{"typography":{"fontWeight":"600"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
			<div class="wp-block-column" style="font-weight:600;flex-basis:67%">
				<!-- wp:paragraph {"fontSize":"small"} -->
				<p class="has-small-font-size"><?php esc_html_e( 'Russet Organic Potatoes', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"33%","layout":{"type":"constrained","justifyContent":"right"}} -->
			<div class="wp-block-column" style="flex-basis:33%">
				<!-- wp:paragraph {"align":"left","fontSize":"small"} -->
				<p class="has-text-align-left has-small-font-size"><?php esc_html_e( 'from $1.49', 'woocommerce' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:column -->
</div>
<!-- /wp:columns -->
