<?php
/**
 * Custom Settings for Home v11
 */

acf_add_local_field_group(array(
    'key' => 'group_611def8d3c27b',
    'title' => esc_html__( 'Home v11 Options', 'electro' ),
    'fields' => array(
        array(
            'key' => 'field_611defd8770b3',
            'label' => esc_html__( 'General', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_611deff1770b4',
            'label' => esc_html__( 'Header Style', 'electro' ),
            'name' => 'home_v11_header_style',
            'type' => 'select',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'v1' => 'Header v1',
                'v2' => 'Header v2',
                'v3' => 'Header v3',
                'v4' => 'Header v4',
                'v5' => 'Header v5',
                'v6' => 'Header v6',
                'v7' => 'Header v7',
                'v8' => 'Header v8',
                'v9' => 'Header v9',
                'v10' => 'Header v10',
                'v11' => 'Header v11',
                'v12' => 'Header v12',
            ),
            'default_value' => 'v11',
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 1,
            'ajax' => 0,
            'return_format' => 'value',
            'placeholder' => '',
        ),
        array(
            'key' => 'field_6123a0896a91e',
            'label' => esc_html__( 'Block', 'electro' ),
            'name' => 'home_v11_block',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'row',
            'sub_fields' => array(
                array(
                    'key' => 'field_6123a0a16a91f',
                    'label' => esc_html__( 'Page Content', 'electro' ),
                    'name' => 'page_content',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6123a0eb6a920',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_6123a1176a921',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 5,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_6123a1336a922',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 0,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6123b2959f9ab',
                    'label' => esc_html__( 'Slider', 'electro' ),
                    'name' => 'slider',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6123b2959f9ac',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_6123b2959f9ad',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 10,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_6123b2959f9ae',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6123b2c69f9af',
                    'label' => esc_html__( 'Brands with Categories', 'electro' ),
                    'name' => 'bwc',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6123b2c69f9b0',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_6123b2c69f9b1',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 20,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_6123b2c69f9b2',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6123b2e39f9b3',
                    'label' => esc_html__( 'Banner with Products Carousel', 'electro' ),
                    'name' => 'bwpc',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6123b2e39f9b4',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_6123b2e39f9b5',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 30,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_6123b2e39f9b6',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6123b30d9f9b7',
                    'label' => esc_html__( 'Two Banners', 'electro' ),
                    'name' => 'banners',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6123b30d9f9b8',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_6123b30d9f9b9',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 40,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_6123b30d9f9ba',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6123b3309f9bb',
                    'label' => esc_html__( 'Products Carousel', 'electro' ),
                    'name' => 'prc',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6123b3309f9bc',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_6123b3309f9bd',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 50,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_6123b3309f9be',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6123b3509f9bf',
                    'label' => esc_html__( 'Trending Products Carousel', 'electro' ),
                    'name' => 'tpc',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6123b3519f9c0',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_6123b3519f9c1',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 60,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_6123b3519f9c2',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_611df42be8767',
            'label' => esc_html__( 'Slider', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_6123b2959f9ae',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_611df43ae8768',
            'label' => esc_html__( 'Background Image', 'electro' ),
            'name' => 'homev11_slider_bg_image',
            'type' => 'image',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'large',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_611df51364125',
            'label' => esc_html__( 'Slider Shortcode', 'electro' ),
            'name' => 'home_v11_slider_shortcode',
            'type' => 'text',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_611e06fd7a235',
            'label' => esc_html__( 'Brands with Categories', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_6123b2c69f9b2',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_611e07267a236',
            'label' => esc_html__( 'Brands', 'electro' ),
            'name' => 'home_v11_brands',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_611e07677a237',
                    'label' => esc_html__( 'Title', 'electro' ),
                    'name' => 'title',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Brands:',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_611e079c7a238',
                    'label' => esc_html__( 'More Brands Text', 'electro' ),
                    'name' => 'more_brands_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '+ More Brands',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_611e07bb7a239',
                    'label' => esc_html__( 'More Brands URL', 'electro' ),
                    'name' => 'more_brands_url',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_611e0e6873c48',
                    'label' => esc_html__( 'Limit', 'electro' ),
                    'name' => 'limit',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 6,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_611e0fbf24773',
                    'label' => esc_html__( 'Orderby', 'electro' ),
                    'name' => 'orderby',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'name' => 'Name',
                        'slug' => 'Slug',
                        'id' => 'ID',
                    ),
                    'default_value' => 'name',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_611e103524774',
                    'label' => esc_html__( 'Order', 'electro' ),
                    'name' => 'order',
                    'type' => 'button_group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ASC' => 'ASC',
                        'DESC' => 'DESC',
                    ),
                    'allow_null' => 0,
                    'default_value' => 'ASC',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_611e10b39e252',
                    'label' => esc_html__( 'Hide Empty ?', 'electro' ),
                    'name' => 'hide_empty',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => 'Whether to hide brands not assigned to any products',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_611e6388c972f',
            'label' => esc_html__( 'Categories', 'electro' ),
            'name' => 'home_v11_categories',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_611e653500de2',
                    'label' => esc_html__( 'Arrow Icon', 'electro' ),
                    'name' => 'arrow_icon',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'fas fa-chevron-right',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_611e6388c9733',
                    'label' => esc_html__( 'Limit', 'electro' ),
                    'name' => 'limit',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 8,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_611e6388c9734',
                    'label' => esc_html__( 'Orderby', 'electro' ),
                    'name' => 'orderby',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'name' => 'Name',
                        'slug' => 'Slug',
                        'id' => 'ID',
                    ),
                    'default_value' => 'name',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_611e6388c9735',
                    'label' => esc_html__( 'Order', 'electro' ),
                    'name' => 'order',
                    'type' => 'button_group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ASC' => 'ASC',
                        'DESC' => 'DESC',
                    ),
                    'allow_null' => 0,
                    'default_value' => 'ASC',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_611e6388c9736',
                    'label' => esc_html__( 'Hide Empty ?', 'electro' ),
                    'name' => 'hide_empty',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => 'Whether to hide categories not assigned to any products',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_611e6872b4321',
                    'label' => esc_html__( 'Select Categories', 'electro' ),
                    'name' => 'ids',
                    'type' => 'taxonomy',
                    'instructions' => 'Choose a parent category you want to display.',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'taxonomy' => 'product_cat',
                    'field_type' => 'multi_select',
                    'allow_null' => 0,
                    'add_term' => 0,
                    'save_terms' => 0,
                    'load_terms' => 0,
                    'return_format' => 'id',
                    'multiple' => 0,
                ),
                array(
                    'key' => 'field_611e6e402dac5',
                    'label' => esc_html__( 'Child Categories Limit', 'electro' ),
                    'name' => 'child_limit',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_611e710ce21d7',
                    'label' => esc_html__( 'More Child Text', 'electro' ),
                    'name' => 'more_child_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '...',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_6123293d73f76',
            'label' => esc_html__( 'Banner with Products Carousel', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_6123b2e39f9b6',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_612358266af60',
            'label' => esc_html__( 'Background Image', 'electro' ),
            'name' => 'home_v11_bwpc_bg_image',
            'type' => 'image',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'large',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_612329a84562f',
            'label' => esc_html__( 'Banner', 'electro' ),
            'name' => 'home_v11_bwpc_banner',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_612329f045630',
                    'label' => esc_html__( 'Title', 'electro' ),
                    'name' => 'title',
                    'type' => 'textarea',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'OUTLET DEALS <span class="d-block">CLEARANCE</span>',
                    'placeholder' => '',
                    'maxlength' => '',
                    'rows' => 3,
                    'new_lines' => '',
                ),
                array(
                    'key' => 'field_61232a6493979',
                    'label' => esc_html__( 'Subtitle', 'electro' ),
                    'name' => 'subtitle',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'SAVE UP TO',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_61232af59397a',
                    'label' => esc_html__( 'Offer Text', 'electro' ),
                    'name' => 'offer_text',
                    'type' => 'textarea',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '70<sup class="font-size-36">%</sup><sub class="font-size-16">OFF!</sub>',
                    'placeholder' => '',
                    'maxlength' => '',
                    'rows' => 3,
                    'new_lines' => '',
                ),
                array(
                    'key' => 'field_61232b698b29d',
                    'label' => esc_html__( 'Button Text', 'electro' ),
                    'name' => 'button_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Start Buying',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_61232b838b29e',
                    'label' => esc_html__( 'Button URL', 'electro' ),
                    'name' => 'button_url',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_6123656b7e41e',
            'label' => esc_html__( 'Products', 'electro' ),
            'name' => 'home_v11_bwpc_products',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_6123658f7e41f',
                    'label' => esc_html__( 'Products Content', 'electro' ),
                    'name' => 'content',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent_products' => 'Recent Products',
                        'featured_products' => 'Featured Products',
                        'sale_products' => 'Sale Products',
                        'best_selling_products' => 'Best Selling Products',
                        'top_rated_products' => 'Top Rated products',
                        'products' => 'Products',
                    ),
                    'default_value' => 'recent_products',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_612365b87e420',
                    'label' => esc_html__( 'Choose Products', 'electro' ),
                    'name' => 'ids',
                    'type' => 'relationship',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_6123658f7e41f',
                                'operator' => '==',
                                'value' => 'products',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'post_type' => array(
                        0 => 'product',
                    ),
                    'taxonomy' => '',
                    'filters' => array(
                        0 => 'search',
                        1 => 'post_type',
                        2 => 'taxonomy',
                    ),
                    'elements' => array(
                        0 => 'featured_image',
                    ),
                    'min' => '',
                    'max' => '',
                    'return_format' => 'id',
                ),
                array(
                    'key' => 'field_612365fe7e421',
                    'label' => esc_html__( 'Products Limit', 'electro' ),
                    'name' => 'limit',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 10,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_612366497e422',
                    'label' => esc_html__( 'Orderby', 'electro' ),
                    'name' => 'orderby',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'date' => 'Date',
                        'id' => 'Id',
                        'menu_order' => 'Menu Order',
                        'popularity' => 'Popularity',
                        'rand' => 'Rand',
                        'rating' => 'Rating',
                        'title' => 'Title',
                    ),
                    'default_value' => 'date',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_612366677e424',
                    'label' => esc_html__( 'Order', 'electro' ),
                    'name' => 'order',
                    'type' => 'button_group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ASC' => 'ASC',
                        'DESC' => 'DESC',
                    ),
                    'allow_null' => 0,
                    'default_value' => 'ASC',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_61236d44396e3',
                    'label' => esc_html__( 'Carousel Options', 'electro' ),
                    'name' => 'carousel',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_61236d5a396e4',
                            'label' => esc_html__( 'Autoplay', 'electro' ),
                            'name' => 'autoplay',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 0,
                            'ui' => 1,
                            'ui_on_text' => 'Enable',
                            'ui_off_text' => 'Disable',
                        ),
                        array(
                            'key' => 'field_61236d95cc74c',
                            'label' => esc_html__( 'Slide to Show', 'electro' ),
                            'name' => 'slide_to_show',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 5,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => 1,
                            'max' => 10,
                            'step' => '',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_612384ce2e095',
            'label' => esc_html__( 'Two Banners', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_6123b30d9f9ba',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_612384dc2e096',
            'label' => esc_html__( 'Banner #1', 'electro' ),
            'name' => 'home_v11_two_banners_1',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_612385e42e097',
                    'label' => esc_html__( 'Image', 'electro' ),
                    'name' => 'image',
                    'type' => 'image',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_612386022e098',
                    'label' => esc_html__( 'Action Link', 'electro' ),
                    'name' => 'action_link',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_612386532e099',
            'label' => esc_html__( 'Banner #2', 'electro' ),
            'name' => 'home_v11_two_banners_2',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_612386532e09a',
                    'label' => esc_html__( 'Image', 'electro' ),
                    'name' => 'image',
                    'type' => 'image',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_612386532e09b',
                    'label' => esc_html__( 'Action Link', 'electro' ),
                    'name' => 'action_link',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_61238d30d2d95',
            'label' => esc_html__( 'Products Carousel', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_6123b3309f9be',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_61238e3e32d79',
            'label' => esc_html__( 'Products', 'electro' ),
            'name' => 'home_v11_products_carousel',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61238ffd32d82',
                    'label' => esc_html__( 'Section Title', 'electro' ),
                    'name' => 'section_title',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Price Deals',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_6123906932d83',
                    'label' => esc_html__( 'Action Text', 'electro' ),
                    'name' => 'action_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Go to Daily Deals Section',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_6123908632d84',
                    'label' => esc_html__( 'Action Link', 'electro' ),
                    'name' => 'action_link',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_61238e3e32d7a',
                    'label' => esc_html__( 'Products Content', 'electro' ),
                    'name' => 'content',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent_products' => 'Recent Products',
                        'featured_products' => 'Featured Products',
                        'sale_products' => 'Sale Products',
                        'best_selling_products' => 'Best Selling Products',
                        'top_rated_products' => 'Top Rated products',
                        'products' => 'Products',
                    ),
                    'default_value' => 'recent_products',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_61238e3e32d7b',
                    'label' => esc_html__( 'Choose Products', 'electro' ),
                    'name' => 'ids',
                    'type' => 'relationship',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_61238e3e32d7a',
                                'operator' => '==',
                                'value' => 'products',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'post_type' => array(
                        0 => 'product',
                    ),
                    'taxonomy' => '',
                    'filters' => array(
                        0 => 'search',
                        1 => 'post_type',
                        2 => 'taxonomy',
                    ),
                    'elements' => array(
                        0 => 'featured_image',
                    ),
                    'min' => '',
                    'max' => '',
                    'return_format' => 'id',
                ),
                array(
                    'key' => 'field_61238e3e32d7c',
                    'label' => esc_html__( 'Products Limit', 'electro' ),
                    'name' => 'limit',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 10,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_61238e3e32d7d',
                    'label' => esc_html__( 'Orderby', 'electro' ),
                    'name' => 'orderby',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'date' => 'Date',
                        'id' => 'Id',
                        'menu_order' => 'Menu Order',
                        'popularity' => 'Popularity',
                        'rand' => 'Rand',
                        'rating' => 'Rating',
                        'title' => 'Title',
                    ),
                    'default_value' => 'date',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_61238e3e32d7e',
                    'label' => esc_html__( 'Order', 'electro' ),
                    'name' => 'order',
                    'type' => 'button_group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ASC' => 'ASC',
                        'DESC' => 'DESC',
                    ),
                    'allow_null' => 0,
                    'default_value' => 'ASC',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_612391cc5d428',
                    'label' => esc_html__( 'Carousel Autoplay', 'electro' ),
                    'name' => 'autoplay',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => 'Enable',
                    'ui_off_text' => 'Disable',
                ),
                array(
                    'key' => 'field_612391e75d429',
                    'label' => esc_html__( 'Carousel Slide To Show', 'electro' ),
                    'name' => 'slide_to_show',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 7,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_61239c102c554',
            'label' => esc_html__( 'Trending Products Carousel', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_6123b3519f9c2',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_61239c1f2c555',
            'label' => esc_html__( 'Products', 'electro' ),
            'name' => 'home_v11_trending_products_carousel',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61239c1f2c556',
                    'label' => esc_html__( 'Section Title', 'electro' ),
                    'name' => 'section_title',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Trending products',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_61239c1f2c557',
                    'label' => esc_html__( 'Action Text', 'electro' ),
                    'name' => 'action_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Go to Trending products',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_61239c1f2c558',
                    'label' => esc_html__( 'Action Link', 'electro' ),
                    'name' => 'action_link',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_61239c1f2c559',
                    'label' => esc_html__( 'Products Content', 'electro' ),
                    'name' => 'content',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent_products' => 'Recent Products',
                        'featured_products' => 'Featured Products',
                        'sale_products' => 'Sale Products',
                        'best_selling_products' => 'Best Selling Products',
                        'top_rated_products' => 'Top Rated products',
                        'products' => 'Products',
                    ),
                    'default_value' => 'recent_products',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_61239c1f2c55a',
                    'label' => esc_html__( 'Choose Products', 'electro' ),
                    'name' => 'ids',
                    'type' => 'relationship',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_61239c1f2c559',
                                'operator' => '==',
                                'value' => 'products',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'post_type' => array(
                        0 => 'product',
                    ),
                    'taxonomy' => '',
                    'filters' => array(
                        0 => 'search',
                        1 => 'post_type',
                        2 => 'taxonomy',
                    ),
                    'elements' => array(
                        0 => 'featured_image',
                    ),
                    'min' => '',
                    'max' => '',
                    'return_format' => 'id',
                ),
                array(
                    'key' => 'field_61239c1f2c55b',
                    'label' => esc_html__( 'Products Limit', 'electro' ),
                    'name' => 'limit',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 10,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_61239c1f2c55c',
                    'label' => esc_html__( 'Orderby', 'electro' ),
                    'name' => 'orderby',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'date' => 'Date',
                        'id' => 'Id',
                        'menu_order' => 'Menu Order',
                        'popularity' => 'Popularity',
                        'rand' => 'Rand',
                        'rating' => 'Rating',
                        'title' => 'Title',
                    ),
                    'default_value' => 'date',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_61239c1f2c55d',
                    'label' => esc_html__( 'Order', 'electro' ),
                    'name' => 'order',
                    'type' => 'button_group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ASC' => 'ASC',
                        'DESC' => 'DESC',
                    ),
                    'allow_null' => 0,
                    'default_value' => 'ASC',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_61239c1f2c55e',
                    'label' => esc_html__( 'Carousel Autoplay', 'electro' ),
                    'name' => 'autoplay',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => 'Enable',
                    'ui_off_text' => 'Disable',
                ),
                array(
                    'key' => 'field_61239c1f2c55f',
                    'label' => esc_html__( 'Carousel Slide To Show', 'electro' ),
                    'name' => 'slide_to_show',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 7,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'page',
            ),
            array(
                'param' => 'post_template',
                'operator' => '==',
                'value' => 'template-homepage-v11.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'field',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
));