jQuery(document).ready(function ($) {
	const order_id = phpTrackVariables.order_id;
	const ajax_url = phpTrackVariables.ajax_url;
	const tracking_awb_number = phpTrackVariables.tracking_id;
	const carrier_id = phpTrackVariables.carrier_id;
	window.tracking_shipment_details = function () {
		$(".error-message").empty();
		let hasError = false;
		if (tracking_awb_number === "") {
			jQuery("#tracking_main_div_id").prepend(
				'<span class="error-message">AWB Number is missing or not found.</span>'
			);
			hasError = true;
		}

		if (hasError) {
			return false;
		} else {
			var $button = $('button[name="tracking_detail_btn"]');
			var originalText = $button.text();
			$button.prop("disabled", true).html("Please Wait...");
			$.ajax({
				type: "POST",
				url: ajax_url,
				dataType: "json",
				cache: false,
				data: {
					action: "ajax_tracking_shipment_details",
					order_id: order_id,
					tracking_details_action: "tracking_shipment_details",
				},
				success: function (result) {
					$button.prop("disabled", false).html(originalText);
					console.log(result);
					if (result.success) {
						$(".error-message").empty();

						var specific_statuses = [
							"PickupCancelled",
							"ReturnInitiated",
							"Rejected",
							"Undeliverable",
							"Lost",
							"Delivered",
						];
						var shipping_status = result.data.shipping_data.shipping_status;

						var html =
							'<ul class="list-unstyled">' +
							'<li><label for="tracking_details"><strong>Tracking details:</strong></label></li>' +
							"<li>" +
							'<label for="tracking_awb_number">Current Status:</label> ' +
							'<span id="shipping_status">' +
							shipping_status +
							"</span>" +
							"</li>";

						if (!specific_statuses.includes(shipping_status)) {
							// If it is not one of the specific statuses, display the estimated delivery date
							html +=
								"<li>" +
								'<label for="estimated_delivery_date">Estimated Delivery:</label> ' +
								'<span id="estimated_delivery_date">' +
								result.data.shipping_data.estimated_delivery_date +
								"</span>" +
								"</li>";
						}

						html += "</ul>";

						var tracking_history_arr = JSON.parse(
							result.data.shipping_data.tracking_history
						);

						var tracking_event_code = [
							"ReadyForReceive",
							"PickupDone",
							"Delivered",
							"Departed",
							"DeliveryAttempted",
							"Lost",
							"OutForDelivery",
							"ArrivedAtCarrierFacility",
							"Rejected",
							"Undeliverable",
							"PickupCancelled",
							"ReturnInitiated",
							"AvailableForPickup",
						];

						html +=
							'<ul class="list-unstyled">' +
							"<li>" +
							'<label for="tracking_history"><strong>Tracking History:</strong></label>' +
							"</li>" +
							'<div id="tracking-container">';

						// Loop through each tracking event code
						$.each(tracking_event_code, function (index, event_code) {
							if (tracking_history_arr.payload) {
								$.each(
									tracking_history_arr.payload.eventHistory,
									function (i, event_history) {
										if (event_history.eventCode === event_code) {
											var formateddate = new Date(event_history.eventTime);
											var event_date =
												formateddate.getDate().toString().padStart(2, "0") +
												"-" +
												(formateddate.getMonth() + 1)
													.toString()
													.padStart(2, "0") +
												"-" +
												formateddate.getFullYear();

											html +=
												'<li><label for="tracking_awb_number">' +
												event_code +
												":</label> ";
											html += "<span>" + event_date + "</span></li>";

											return false; // Break the inner loop
										}
									}
								);
							}
						});
						html += "</div></ul>";

						$(".tracking-details").html(html);
						location.reload();
					} else {
						$button.prop("disabled", false).html(originalText);
						$(".error-message").empty();
						$("#tracking_main_div_id").prepend(
							'<span class="error-message">' +
								result.data.message +
								" " +
								result.data.detail_error_message +
								"</span>"
						);
					}
				},
				error: function (error) {
					console.log("Error:", error);
					$button.prop("disabled", false).html(originalText);
				},
			});
		}
	};
});
