<?php

/**
 * Plugin Name: AuroShip
 * Plugin URI: https://www.aurobees.com/
 * Description: Aurobees WooCommerce plugin to connect with Amazon Shipping Service in India.
 * Author: Aurionpro Solutions
 * Author URI: https://www.aurobees.com/
 * Version: 1.0.0
 * Requires at least: 5.6
 * Tested up to: 5.6
 *
 * @package AuroShip
 * @link    https://www.aurobees.com/
 */

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( is_admin() ) {
	add_filter(
		'plugin_action_links_' . plugin_basename( __FILE__ ),
		function ( $links ) {
			$plugin_links = array(
				'<a href="admin.php?page=auroship-settings">' . esc_html__( 'Settings', 'auroship-settings' ) . '</a>',
			);
			return array_merge( $plugin_links, $links );
		}
	);
}

/**
 * Check if WooCommerce is active
 **/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	define( 'AUROSHIP_MAIN_FILE', __FILE__ );
	define( 'AUROSHIP_PLUGIN_URL', untrailingslashit( plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) ) );
	define( 'AUROSHIP_PLUGIN_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
	define( 'AUROSHIP_PLUGIN_NAME', 'auroship' );
	define( 'AUROSHIP_TIMEZONE', 'Asia/Kolkata' );
	define( 'AUROSHIP_PLUGIN_VERSION', '1.0.0' );
	include_once plugin_dir_path( __FILE__ ) . 'includes/class-generate-label.php';
	include_once plugin_dir_path( __FILE__ ) . 'includes/auroship-settings.php';
	include_once plugin_dir_path( __FILE__ ) . 'includes/order-statuses-creation.php';
}
