<?php

/**
 * An external standard for AuroShip.
 *
 * @package  AuroShip
 * @link     https://www.aurobees.com/
 */
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

define( 'AUROSHIP_SETTING_PAGE', 'auroship-settings' );
define( 'AUROSHIP_SETTING_SECTION', 'auroship_setting_section' );

/**
 * Create Settings Menu
 *
 * @return void
 */
if ( !function_exists( 'auroship_settings' ) ) {
	function auroship_settings() {
		add_menu_page(
			__( 'AuroShip  Settingss', 'auroship-settings' ),
			__( 'AuroShip Settings', 'auroship-settings' ),
			'manage_options',
			'auroship-settings',
			'auroship_settings_callback',
			AUROSHIP_PLUGIN_URL . '/assets/images/icons/auropay.png',
			null
		);
	}
}

add_action( 'admin_menu', 'auroship_settings' );

/**
 * Settings Template Page
 *
 * @return void
 */
if ( !function_exists( 'auroship_settings_callback' ) ) {
	function auroship_settings_callback() {
		?>
<div class="wrap">
	<form action="options.php" method="post">
		<?php
// security field
		settings_fields( AUROSHIP_SETTING_PAGE );

		// output settings section here
		do_settings_sections( AUROSHIP_SETTING_PAGE );

		// save settings button
		submit_button( 'Save Settings' );
		?>
	</form>
</div>
<?php
}
}

/**
 * Settings initiate
 *
 * @return void
 */
if ( !function_exists( 'auroship_settings_init' ) ) {
	function auroship_settings_init() {
		// Setup settings section
		add_settings_section(
			AUROSHIP_SETTING_SECTION,
			'Auroship Settings',
			'',
			AUROSHIP_SETTING_PAGE
		);
		auroship_register_general_settings();
		auroship_register_api_settings();
		auroship_register_additional_settings();
	}
}
add_action( 'admin_init', 'auroship_settings_init' );

/**
 * Register and initialize general settings.
 *
 * @return void
 */
function auroship_register_general_settings() {

	// Register title field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_title',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => 'AuroShip',
		)
	);

	// Add title fields
	add_settings_field(
		'auroship_title',
		__( 'Title', 'auroship' ),
		'auroship_title_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register description field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_description',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_textarea_field',
			'default' => 'Aurobees WooCommerce plugin to connect with Amazon Shipping Service in India',
		)
	);

	// Add description fields
	add_settings_field(
		'auroship_description',
		__( 'Description', 'auroship' ),
		'auroship_description_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register test mode field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_test_mode',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add test mode field
	add_settings_field(
		'auroship_test_mode',
		__( 'Test Mode', 'auroship' ),
		'auroship_test_mode_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);
}

/**
 * Register and initialize API settings.
 *
 * @return void
 */
function auroship_register_api_settings() {
	// Register api url field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_api_url',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add api url fields
	add_settings_field(
		'auroship_api_url',
		__( 'Amazon OAuth API URL', 'auroship' ),
		'auroship_api_url_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register client id field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_client_id',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add client id fields
	add_settings_field(
		'auroship_client_id',
		__( 'Client Id', 'auroship' ),
		'auroship_client_id_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register client secret field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_client_secret',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add client secret fields
	add_settings_field(
		'auroship_client_secret',
		__( 'Client Secret', 'auroship' ),
		'auroship_client_secret_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register refresh token field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_refresh_token',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add refresh token fields
	add_settings_field(
		'auroship_refresh_token',
		__( 'Refresh Token', 'auroship' ),
		'auroship_refresh_token_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	/*
		// Register grant type field
		register_setting(
			AUROSHIP_SETTING_PAGE,
			'auroship_grant_type',
			array(
				'type' => 'string',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => '',
			)
		);

		// Add grant type fields
		add_settings_field(
			'auroship_grant_type',
			__( 'Grant Type', 'auroship' ),
			'auroship_grant_type_callback',
			AUROSHIP_SETTING_PAGE,
			AUROSHIP_SETTING_SECTION
		);
	*/

	// Register seller api field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_seller_api_url',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add seller api fields
	add_settings_field(
		'auroship_seller_api_url',
		__( 'Amazon Shipping V2 API URL', 'auroship' ),
		'auroship_seller_api_url_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

}

/**
 * Register and initialize API settings.
 *
 * @return void
 */
function auroship_register_additional_settings() {

	// Add amazon shipping business id fields
	add_settings_field(
		'auroship_amzn_shipng_bsns_id',
		__( 'Amazon Shipping Business Id', 'auroship' ),
		'auroship_amzn_shipng_bsns_id_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register amazon shipping business id field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_amzn_shipng_bsns_id',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add tax registration number fields
	add_settings_field(
		'auroship_tax_registration_number',
		__( 'Tax Registration Number', 'auroship' ),
		'auroship_tax_registration_number_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register tax registration number field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_tax_registration_number',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);
	// Add amazon service id fields
	add_settings_field(
		'auroship_amzn_service_id',
		__( 'Amazon Service Id', 'auroship' ),
		'auroship_amzn_service_id_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register amazon service id field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_amzn_service_id',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Register Log field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_logging',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add Log field
	add_settings_field(
		'auroship_logging',
		__( 'Logging', 'auroship' ),
		'auroship_logging_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Add max product weight fields
	add_settings_field(
		'auroship_max_gross_weight',
		__( 'Max Gross Weight(g)', 'auroship' ),
		'auroship_max_gross_weight_callback',
		AUROSHIP_SETTING_PAGE,
		AUROSHIP_SETTING_SECTION
	);

	// Register max product weight field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_max_gross_weight',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	add_settings_section(
		'auroship_dimension_section',
		__( 'Package Dimensions', 'auroship' ), // Common title
		'auroship_dimension_section_callback', // Callback function to display content
		AUROSHIP_SETTING_PAGE
	);

	// Add max length fields
	add_settings_field(
		'auroship_max_length',
		__( 'Max Length(cm)', 'auroship' ),
		'auroship_max_length_callback',
		AUROSHIP_SETTING_PAGE,
		'auroship_dimension_section'
	);

	// Register max length field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_max_length',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add max width fields
	add_settings_field(
		'auroship_max_width',
		__( 'Max Width(cm)', 'auroship' ),
		'auroship_max_width_callback',
		AUROSHIP_SETTING_PAGE,
		'auroship_dimension_section'
	);

	// Register max width field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_max_width',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);

	// Add max height fields
	add_settings_field(
		'auroship_max_height',
		__( 'Max Height(cm)', 'auroship' ),
		'auroship_max_height_callback',
		AUROSHIP_SETTING_PAGE,
		'auroship_dimension_section'
	);

	// Register max height field
	register_setting(
		AUROSHIP_SETTING_PAGE,
		'auroship_max_height',
		array(
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '',
		)
	);
}

/**
 * Title template
 *
 * @return void
 */
if ( !function_exists( 'auroship_title_callback' ) ) {
	function auroship_title_callback() {
		$auroship_title = get_option( 'auroship_title' );
		?>
<input type="text" name="auroship_title" readonly class="regular-text"
	value="<?php echo isset( $auroship_title ) ? esc_attr( $auroship_title ) : ''; ?>" />
<?php
}
}

/**
 * Description template
 *
 * @return void
 */
if ( !function_exists( 'auroship_description_callback' ) ) {
	function auroship_description_callback() {
		$auroship_description = get_option( 'auroship_description' );
		?>
<textarea name="auroship_description" readonly class="large-text"
	rows="2"><?php echo isset( $auroship_description ) ? esc_textarea( $auroship_description ) : ''; ?></textarea>
<?php
}
}

/**
 * Test Mode
 *
 * @return void
 */
if ( !function_exists( 'auroship_test_mode_callback' ) ) {
	function auroship_test_mode_callback() {
		$auroship_test_mode = get_option( 'auroship_test_mode' );
		?>
<input type="checkbox" name="auroship_test_mode" class="regular-text" value="test_mode"
	<?php checked( 'test_mode', $auroship_test_mode );?> /> Test Mode
<br /><br /><span>Use test mode using test credentials.</span>

<?php
}
}

/**
 * Api url template
 *
 * @return void
 */
if ( !function_exists( 'auroship_api_url_callback' ) ) {
	function auroship_api_url_callback() {
		$auroship_api_url = get_option( 'auroship_api_url' );
		?>
<input type="text" name="auroship_api_url" class="regular-text"
	value="<?php echo isset( $auroship_api_url ) ? esc_attr( $auroship_api_url ) : ''; ?>" />

<?php
}
}

/**
 * Client Id template
 *
 * @return void
 */
if ( !function_exists( 'auroship_client_id_callback' ) ) {
	function auroship_client_id_callback() {
		$auroship_client_id = get_option( 'auroship_client_id' );
		?>
<input type="password" name="auroship_client_id" class="regular-text"
	value="<?php echo isset( $auroship_client_id ) ? esc_attr( $auroship_client_id ) : ''; ?>" />

<?php
}
}
/**
 * Client Secret template
 *
 * @return void
 */
if ( !function_exists( 'auroship_client_secret_callback' ) ) {
	function auroship_client_secret_callback() {
		$auroship_client_secret = get_option( 'auroship_client_secret' );
		?>
<input type="password" name="auroship_client_secret" class="regular-text"
	value="<?php echo isset( $auroship_client_secret ) ? esc_attr( $auroship_client_secret ) : ''; ?>" />
<?php
}
}

/**
 * Refresh Token template
 *
 * @return void
 */
if ( !function_exists( 'auroship_refresh_token_callback' ) ) {
	function auroship_refresh_token_callback() {
		$auroship_refresh_token = get_option( 'auroship_refresh_token' );
		?>
<input type="password" name="auroship_refresh_token" class="regular-text"
	value="<?php echo isset( $auroship_refresh_token ) ? esc_attr( $auroship_refresh_token ) : ''; ?>" />

<?php
}
}

/**
 * Grant type template
 *
 * @return void
 */

/*
if ( !function_exists( 'auroship_grant_type_callback' ) ) {
function auroship_grant_type_callback() {
$auroship_grant_type = get_option( 'auroship_grant_type' );
?>
<input type="text" name="auroship_grant_type" class="regular-text"
value="<?php echo isset( $auroship_grant_type ) ? esc_attr( $auroship_grant_type ) : ''; ?>" />
<?php
}
}
 */

/**
 * Amazon shipping business id template
 *
 * @return void
 */
if ( !function_exists( 'auroship_amzn_shipng_bsns_id_callback' ) ) {
	function auroship_amzn_shipng_bsns_id_callback() {
		$auroship_amzn_shipng_bsns_id = get_option( 'auroship_amzn_shipng_bsns_id' );
		$options = array(
			'AmazonShipping_US' => 'AmazonShipping_US',
			'AmazonShipping_IN' => 'AmazonShipping_IN',
			'AmazonShipping_UK' => 'AmazonShipping_UK',
			'AmazonShipping_IT' => 'AmazonShipping_IT',
			'AmazonShipping_ES' => 'AmazonShipping_ES',
			'AmazonShipping_FR' => 'AmazonShipping_FR',
		)
		?>
<select name="auroship_amzn_shipng_bsns_id" id="auroship_amzn_shipng_bsns_id" class="regular-text">
	<?php
foreach ( $options as $value ) {
			?>
	<option value="<?php echo $value ?>" <?php selected( $value, $auroship_amzn_shipng_bsns_id )?>><?php echo $value ?>
	</option>;
	<?php
}
		?>
</select>
<?php
}
}

/**
 * Amazon tax registration number template
 *
 * @return void
 */
if ( !function_exists( 'auroship_tax_registration_number_callback' ) ) {
	function auroship_tax_registration_number_callback() {
		$auroship_tax_registration_number = get_option( 'auroship_tax_registration_number' );
		?>
<input type="text" name="auroship_tax_registration_number" class="regular-text"
	value="<?php echo isset( $auroship_tax_registration_number ) ? esc_attr( $auroship_tax_registration_number ) : ''; ?>" />
<?php
}
}

/**
 * Max gross weight template
 *
 * @return void
 */
if ( !function_exists( 'auroship_max_gross_weight_callback' ) ) {
	function auroship_max_gross_weight_callback() {
		$auroship_max_gross_weight = get_option( 'auroship_max_gross_weight' );
		?>
<input type="text" name="auroship_max_gross_weight" class="regular-text"
	value="<?php echo isset( $auroship_max_gross_weight ) ? esc_attr( $auroship_max_gross_weight ) : ''; ?>" />
<?php
}
}

/**
 * Package dimensions template
 *
 * @return void
 */
function auroship_dimension_section_callback() {
	echo '<p>' . __( 'Please enter the maximum dimensions for the package.', 'auroship' ) . '</p>';
}

/**
 * Max length template
 *
 * @return void
 */
if ( !function_exists( 'auroship_max_length_callback' ) ) {
	function auroship_max_length_callback() {
		$auroship_max_length = get_option( 'auroship_max_length' );
		?>
<input type="text" name="auroship_max_length" class="regular-text"
	value="<?php echo isset( $auroship_max_length ) ? esc_attr( $auroship_max_length ) : ''; ?>" />
<?php
}
}

/**
 * Max width template
 *
 * @return void
 */
if ( !function_exists( 'auroship_max_width_callback' ) ) {
	function auroship_max_width_callback() {
		$auroship_max_width = get_option( 'auroship_max_width' );
		?>
<input type="text" name="auroship_max_width" class="regular-text"
	value="<?php echo isset( $auroship_max_width ) ? esc_attr( $auroship_max_width ) : ''; ?>" />
<?php
}
}

/**
 * Max height template
 *
 * @return void
 */
if ( !function_exists( 'auroship_max_height_callback' ) ) {
	function auroship_max_height_callback() {
		$auroship_max_height = get_option( 'auroship_max_height' );
		?>
<input type="text" name="auroship_max_height" class="regular-text"
	value="<?php echo isset( $auroship_max_height ) ? esc_attr( $auroship_max_height ) : ''; ?>" />
<?php
}
}

/**
 * Amazon service id template
 *
 * @return void
 */
if ( !function_exists( 'auroship_amzn_service_id_callback' ) ) {
	function auroship_amzn_service_id_callback() {
		$auroship_amzn_service_id = get_option( 'auroship_amzn_service_id' );
		$options = array(
			'SWA-IN-OA' => 'SWA-IN-OA',
		)
		?>
<select name="auroship_amzn_service_id" id="auroship_amzn_service_id" class="regular-text">
	<?php
foreach ( $options as $value ) {
			?>
	<option value="<?php echo $value ?>" <?php selected( $value, $auroship_amzn_service_id )?>><?php echo $value ?>
	</option>;
	<?php
}
		?>
</select>
<?php
}
}

/**
 * Seller api url template
 *
 * @return void
 */
if ( !function_exists( 'auroship_seller_api_url_callback' ) ) {
	function auroship_seller_api_url_callback() {
		$auroship_seller_api_url = get_option( 'auroship_seller_api_url' );
		?>
<input type="text" name="auroship_seller_api_url" class="regular-text"
	value="<?php echo isset( $auroship_seller_api_url ) ? esc_attr( $auroship_seller_api_url ) : ''; ?>" />

<?php
}
}

/**
 * Logging
 *
 * @return void
 */
if ( !function_exists( 'auroship_logging_callback' ) ) {
	function auroship_logging_callback() {
		$auroship_logging = get_option( 'auroship_logging' );
		?>
<input type="checkbox" name="auroship_logging" class="regular-text" value="logging"
	<?php checked( 'logging', $auroship_logging );?> /> Log debug messages
<br /><br /><span>Save debug messages into log.</span>

<?php
}
}
