<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'wp_ajax_ajax_tracking_shipment_details', 'auroship_ajax_tracking_details' );
add_action( 'wp_enqueue_scripts', 'auroship_tracking_details_js' );

/**
 * Get the data after generating the label
 *
 * @return string
 */
function auroship_ajax_tracking_details() {
	if ( isset( $_POST['tracking_details_action'] ) && 'tracking_shipment_details' == $_POST['tracking_details_action'] ) {
		$order_id = isset( $_POST['order_id'] ) ? intval( $_POST['order_id'] ) : 0;

		$tracking_id = get_post_meta( $order_id, '_tracking_id', true );
		$carrier_id = get_post_meta( $order_id, '_carrier_id', true );
		$params['trackingId'] = $tracking_id;
		$params['carrierId'] = $carrier_id;
		$res = Auroship_API::get_shipping_tracking( $params, $order_id );

		$departed_found = false;
		$delivered_found = false;

		if ( !empty( $res['success'] ) ) {
			$order = wc_get_order( $order_id );

			$tracking_id = get_post_meta( $order_id, '_tracking_id', true );
			$promised_delivery_date = get_post_meta( $order_id, '_promised_delivery_date', true );
			$tracking_history = get_post_meta( $order_id, '_tracking_history', true );
			$shipping_status = get_post_meta( $order_id, '_shipping_status', true );

			$date1 = new DateTime( $promised_delivery_date );
			$estimated_delivery_date = $date1->format( 'd-m-Y' );
			$shipping_data = [
				'tracking_id' => $tracking_id,
				'estimated_delivery_date' => $estimated_delivery_date,
				'tracking_history' => $tracking_history,
				'shipping_status' => $shipping_status,
			];

			$tracking_history_data = json_decode( $tracking_history, true );

			// Check the eventHistory array for Departed and Delivered events
			if ( isset( $tracking_history_data['payload']['eventHistory'] ) && is_array( $tracking_history_data['payload']['eventHistory'] ) ) {
				foreach ( $tracking_history_data['payload']['eventHistory'] as $event ) {
					if ( isset( $event['eventCode'] ) ) {
						if ( 'Departed' === $event['eventCode'] ) {
							$departed_found = true;
						}
						if ( 'Delivered' === $event['eventCode'] ) {
							$delivered_found = true;
						}
					}
				}
			}

			$status = '';

			if ( $departed_found && !$delivered_found ) {
				if ( $order->get_status() !== 'shipped' && $order->get_status() !== 'delivered' ) {
					$order->update_status( 'shipped' );
					$status = 'shipped';
				}
			} elseif ( $delivered_found ) {
				if ( $order->get_status() !== 'delivered' ) {
					$order->update_status( 'delivered' );
					$status = 'delivered';
				}
			}

			$response = array( 'shipping_data' => $shipping_data );

			wp_send_json_success( $response );
			die();
		} else {
			wp_send_json_error( $res );
			die();
		}
	}
}

/**
 * JavaScript functionality to get tracking info
 *
 * @return void
 */
function auroship_tracking_details_js() {
	if ( is_account_page() && is_wc_endpoint_url( 'view-order' ) ) {
		wp_enqueue_script( 'jquery' );
		wp_register_script( 'tracking-details-script', AUROSHIP_PLUGIN_URL . '/assets/js/tracking-shipment-details-script.js', array( 'jquery' ), null, true );
		$orderid = 0;

		if ( is_account_page() && get_query_var( 'view-order' ) ) {
			$order_id = get_query_var( 'view-order' );
			$orderid = intval( $order_id );
			$tracking_id = get_post_meta( $orderid, '_tracking_id', true );
			$carrier_id = get_post_meta( $orderid, '_carrier_id', true );
		}

		$php_data = array(
			'order_id' => $orderid,
			'tracking_id' => $tracking_id,
			'carrier_id' => $carrier_id,
			'ajax_url' => admin_url( 'admin-ajax.php' ),
		);

		wp_localize_script( 'tracking-details-script', 'phpTrackVariables', $php_data );
		wp_enqueue_script( 'tracking-details-script' );
	}
}
?>
