<div style="width: 100%;">
    <div class="dokan-panel dokan-panel-default" id="dokan-panel-div">
        <div class="dokan-panel-heading"><strong><?php esc_html_e( 'Shipment Tracking', 'auroship' );?></strong></div>
        <div class="dokan-panel-body general-details no-border">
            <div class="options_group padding-bottom-10">
                <p class="form-field">
                    <label for="tracking_awb_number_dokan"><?php esc_html_e( 'AWB Number', 'auroship' );?></label>
                    <input type="text" readonly name="tracking_awb_number_dokan" id="tracking_awb_number_dokan" value="<?php echo esc_attr( $tracking_id ); ?>" placeholder="<?php esc_attr_e( 'AWB Number', 'auroship' );?>" />
                <p id="errMsgTrackNumberDokan" class="error-message"></p>
                </p>
                <p class="form-field">
                    <label for="shipping_provider_dokan"><?php esc_html_e( 'Shipping Provider', 'auroship' );?></label>
                    <input type="text" readonly name="shipping_provider_dokan" id="shipping_provider_dokan" value="<?php echo esc_attr( $shipping_provider ); ?>" placeholder="<?php esc_attr_e( 'Shipping Provider', 'auroship' );?>" />
                    <input type="hidden" name="carrier_id_dokan" id="carrier_id_dokan" value="<?php echo esc_attr( $carrier_id ); ?>" placeholder="<?php esc_attr_e( 'Carrier ID', 'auroship' );?>" />
                <p id="errMsgShippingProviderDokan" class="error-message"></p>
                </p>
            </div>
            <div class="no-border">
                <ul class="order-button">
                    <li class="wide">
                        <button type="button" onclick="tracking_shipment_dokan()" class="button dokan-btn dokan-btn-success" name="tracking_btn_dokan" id="tracking_btn_dokan">
                            <?php esc_html_e( 'Track Shipment', 'auroship' );?>
                        </button>
                    </li>
                </ul>
            </div>
            <?php if ( $shipping_status ) {?>
                <div class="tracking-details">
                    <ul class="list-unstyled">
                        <li>
                            <span for="tracking_details"><strong><?php esc_html_e( 'Tracking Details:', 'auroship' );?></strong></span>
                        </li>
                        <li>
                            <span for="shipping_status_dokan"><?php esc_html_e( 'Current Status:', 'auroship' );?></span>
                            <span class="no-bold" id="shipping_status_dokan"><?php echo esc_html( $shipping_status ); ?></span>
                        </li>
                        <?php if ( !in_array( $shipping_status, $specific_statuses ) ) {?>
                        <li>
                            <span for="estimated_delivery_date_dokan"><?php esc_html_e( 'Estimated Delivery:', 'auroship' );?></span>
                            <span class="no-bold" id="estimated_delivery_date_dokan"><?php echo esc_html( $estimated_delivery_date ); ?></span>
                        </li>
                        <?php }?>
                    </ul>
                    <br>
                    <ul class="list-unstyled">
                        <li>
                            <span for="tracking_history"><strong><?php esc_html_e( 'Tracking History:', 'auroship' );?></strong></span>
                        </li>
                        <div id="tracking-container-dokan">
                            <?php
foreach ( $tracking_event_code as $event_code ) {
	if ( !empty( $tracking_history_arr->payload ) ) {
		foreach ( $tracking_history_arr->payload->eventHistory as $event_history ) {
			if ( $event_history->eventCode === $event_code ) {
				$formatted_date = new DateTime( $event_history->eventTime );
				$event_date = $formatted_date->format( 'd-m-Y' );
				?>
                                            <li>
                                                <span for="tracking_code_dokan"><?php echo esc_html( $event_code ); ?>:</span>
                                                <span class="no-bold"><?php echo esc_html( $event_date ); ?></span>
                                            </li>
                            <?php
break;
			}
		}
	}
}
	?>

                        </div>
                    </ul>
                </div>
            <?php }?>
        </div>
    </div>
</div>
